/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessLog2ExampleSet
extends Operator {
    public static final String PARAMETER_LOG_NAME = "log_name";

    public ProcessLog2ExampleSet(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        DataTable table = null;
        if (this.isParameterSet(PARAMETER_LOG_NAME)) {
            String dataTableName = this.getParameterAsString(PARAMETER_LOG_NAME);
            table = this.getProcess().getDataTable(dataTableName);
        } else if (this.getProcess().getDataTables().size() > 0) {
            table = this.getProcess().getDataTables().iterator().next();
            this.logNote("No log name was specified, using first data table found...");
        }
        if (table == null) {
            throw new UserError(this, 939);
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int i = 0;
        while (i < table.getNumberOfColumns()) {
            String name = table.getColumnName(i);
            if (table.isDate(i)) {
                attributes.add(AttributeFactory.createAttribute(name, 10));
            } else if (table.isDateTime(i)) {
                attributes.add(AttributeFactory.createAttribute(name, 9));
            } else if (table.isNumerical(i)) {
                attributes.add(AttributeFactory.createAttribute(name, 4));
            } else {
                attributes.add(AttributeFactory.createAttribute(name, 1));
            }
            ++i;
        }
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes);
        int r = 0;
        while (r < table.getNumberOfRows()) {
            DataTableRow row = table.getRow(r);
            double[] data = new double[attributes.size()];
            int i2 = 0;
            while (i2 < table.getNumberOfColumns()) {
                if (table.isDate(i2)) {
                    data[i2] = row.getValue(i2);
                } else if (table.isDateTime(i2)) {
                    data[i2] = row.getValue(i2);
                } else if (table.isNumerical(i2)) {
                    data[i2] = row.getValue(i2);
                } else {
                    Attribute attribute = (Attribute)attributes.get(i2);
                    String value = table.getValueAsString(row, i2);
                    data[i2] = attribute.getMapping().mapString(value);
                }
                ++i2;
            }
            exampleTable.addDataRow(new DoubleArrayDataRow(data));
            ++r;
        }
        return new IOObject[]{exampleTable.createExampleSet()};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_LOG_NAME, "The name of the ProcessLog operator which generated the log data which should be transformed (empty: use first found data table).", true));
        return types;
    }
}

