/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import com.rapidminer.tools.math.function.window.WindowFunction;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingAverage
extends AbstractSeriesProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_AGGREGATION_FUNCTION = "aggregation_function";
    public static final String PARAMETER_IGNORE_MISSINGS = "ignore_missings";
    public static final String PARAMETER_RESULT_POSITION = "result_position";
    public static final String[] RESULT_POSITIONS = new String[]{"start", "center", "end"};
    public static final int RESULT_POSITION_START = 0;
    public static final int RESULT_POSITION_CENTER = 1;
    public static final int RESULT_POSITION_END = 2;
    public static final String PARAMETER_WEIGHTING = "window_weighting";
    public static final String PARAMETER_WINDOW_WIDTH = "window_width";
    public static final String PARAMETER_KEEP_ORIGINAL_ATTRIBUTE = "keep_original_attribute";

    public MovingAverage(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        AggregationFunction aggregationFunction;
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        String functionName = AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[this.getParameterAsInt(PARAMETER_AGGREGATION_FUNCTION)];
        try {
            aggregationFunction = AbstractAggregationFunction.createAggregationFunction(functionName, this.getParameterAsBoolean(PARAMETER_IGNORE_MISSINGS));
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        if (!aggregationFunction.supportsAttribute(attribute)) {
            throw new UserError((Operator)this, 136, attribute.getName());
        }
        int windowWidth = this.getParameterAsInt(PARAMETER_WINDOW_WIDTH);
        int resultPosition = this.getParameterAsInt(PARAMETER_RESULT_POSITION);
        int weighting = this.getParameterAsInt(PARAMETER_WEIGHTING);
        Attribute movingAverageAttribute = AttributeFactory.createAttribute("moving_average(" + attribute.getName() + ")", 2);
        exampleSet.getExampleTable().addAttribute(movingAverageAttribute);
        exampleSet.getAttributes().addRegular(movingAverageAttribute);
        Example[] window = new Example[windowWidth];
        double[] values = new double[windowWidth];
        WindowFunction windowFunction = null;
        try {
            switch (resultPosition) {
                case 0: {
                    windowFunction = WindowFunction.createWindowFunction(weighting, 1, windowWidth);
                    break;
                }
                case 1: {
                    windowFunction = WindowFunction.createWindowFunction(weighting, 0, windowWidth);
                    break;
                }
                case 2: {
                    windowFunction = WindowFunction.createWindowFunction(weighting, 2, windowWidth);
                }
            }
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        double[] weights = windowFunction.getWeights();
        int index = 0;
        for (Example example : exampleSet) {
            example.setValue(movingAverageAttribute, Double.NaN);
            if (index < windowWidth - 1) {
                window[index] = example;
                ++index;
                continue;
            }
            window[windowWidth - 1] = example;
            int movingAverageIndex = windowWidth - 1;
            switch (resultPosition) {
                case 0: {
                    movingAverageIndex = 0;
                    break;
                }
                case 1: {
                    if (windowWidth < 3) {
                        movingAverageIndex = 0;
                        break;
                    }
                    if (windowWidth == 3) {
                        movingAverageIndex = 1;
                        break;
                    }
                    movingAverageIndex = (windowWidth - 1) / 2 % 2 == 0 ? (windowWidth - 1) / 2 : (windowWidth - 1) / 2 + 1;
                    break;
                }
                case 2: {
                    movingAverageIndex = windowWidth - 1;
                }
            }
            int i = 0;
            while (i < windowWidth) {
                values[i] = window[i].getValue(attribute);
                ++i;
            }
            window[movingAverageIndex].setValue(movingAverageAttribute, aggregationFunction.calculate(values, weights));
            i = 1;
            while (i < windowWidth) {
                window[i - 1] = window[i];
                ++i;
            }
            ++index;
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(attribute);
        }
        exampleSet.recalculateAttributeStatistics(movingAverageAttribute);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the original series attribute from which the moving average series should be calculated.", false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_WINDOW_WIDTH, "The width of the moving average window.", 2, Integer.MAX_VALUE, 5);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_AGGREGATION_FUNCTION, "The aggregation function that is used for aggregating the values in the window.", AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_IGNORE_MISSINGS, "Ignore missing values in the aggregation of window values.", false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_RESULT_POSITION, "Defines where in the window the result should be placed in the moving average series.", RESULT_POSITIONS, 2);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_WEIGHTING, "The window function that should be used to weight the values in the window for the aggregation.", WindowFunction.FUNCTION_NAMES, 0);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE, "Indicates whether the original attribute should be kept in the data set.", true);
        types.add(type);
        return types;
    }
}

