/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonDominatedSorting
extends Operator {
    public static final String PARAMETER_ATTRIBUTES = "attributes";

    public NonDominatedSorting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        String attributesString = this.getParameterAsString(PARAMETER_ATTRIBUTES);
        Pattern pattern = Pattern.compile(attributesString);
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical() || !pattern.matcher(attribute.getName()).matches()) continue;
            attributeList.add(attribute);
        }
        Attribute[] attributes = new Attribute[attributeList.size()];
        attributeList.toArray(attributes);
        LinkedList<SortingObject> sortingObjects = new LinkedList<SortingObject>();
        int index = 0;
        for (Example example : exampleSet) {
            double[] values = new double[attributes.length];
            int a = 0;
            Attribute[] attributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                values[a] = example.getValue(attribute);
                ++a;
                ++n2;
            }
            sortingObjects.add(new SortingObject(index, values));
            ++index;
        }
        ArrayList<List> ranks = new ArrayList<List>();
        while (sortingObjects.size() > 0) {
            List rank = this.getNextRank(sortingObjects);
            ranks.add(rank);
            Iterator<Object> i = rank.iterator();
            while (i.hasNext()) {
                sortingObjects.remove(i.next());
            }
        }
        sortingObjects.clear();
        for (List rank : ranks) {
            sortingObjects.addAll(rank);
        }
        int[] mapping = new int[sortingObjects.size()];
        index = 0;
        for (SortingObject sortingObject : sortingObjects) {
            mapping[index] = sortingObject.originalIndex;
            ++index;
        }
        MappedExampleSet result = new MappedExampleSet(exampleSet, mapping, true, false);
        return new IOObject[]{result};
    }

    private List<SortingObject> getNextRank(List<SortingObject> population) {
        ArrayList<SortingObject> rank = new ArrayList<SortingObject>();
        int i = 0;
        while (i < population.size()) {
            SortingObject current = population.get(i);
            rank.add(current);
            boolean delete = false;
            int j = rank.size() - 2;
            while (j >= 0) {
                SortingObject ranked = (SortingObject)rank.get(j);
                if (NonDominatedSorting.isDominated(ranked, current)) {
                    rank.remove(ranked);
                }
                if (NonDominatedSorting.isDominated(current, ranked)) {
                    delete = true;
                }
                --j;
            }
            if (delete) {
                rank.remove(current);
            }
            ++i;
        }
        return rank;
    }

    private static boolean isDominated(SortingObject i1, SortingObject i2) {
        double[] pv1 = i1.values;
        double[] pv2 = i2.values;
        double[][] performances = new double[pv1.length][2];
        int p = 0;
        while (p < performances.length) {
            performances[p][0] = pv1[p];
            performances[p][1] = pv2[p];
            ++p;
        }
        boolean dominated = true;
        int p2 = 0;
        while (p2 < performances.length) {
            dominated &= performances[p2][1] >= performances[p2][0];
            ++p2;
        }
        boolean oneActuallyBetter = false;
        int p3 = 0;
        while (p3 < performances.length) {
            oneActuallyBetter |= performances[p3][1] > performances[p3][0];
            ++p3;
        }
        return dominated &= oneActuallyBetter;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTES, "Defines the attributes which should be used for the sorting.", false));
        return types;
    }

    private static class SortingObject {
        private int originalIndex;
        private double[] values;

        public SortingObject(int originalIndex, double[] values) {
            this.originalIndex = originalIndex;
            this.values = values;
        }
    }
}

