/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightOptimization
extends OperatorChain {
    public static final String PARAMETER_PARAMETER = "parameter";
    public static final String PARAMETER_SELECTION_DIRECTION = "selection_direction";
    public static final String PARAMETER_MIN_DIFF = "min_diff";
    public static final String PARAMETER_ITERATIONS_WITHOUT_IMPROVEMENT = "iterations_without_improvement";
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class, AttributeWeights.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ParameterSet.class, PerformanceVector.class, AttributeWeights.class};
    private static final String[] DIRECTIONS = new String[]{"forward selection", "backward elimination"};
    private ParameterSet best;
    private double[] weights;
    private double currentweight;
    private double lastweight;
    private double lastperf;
    private double bestweight;
    private Operator operator;
    private String parameter;
    private double min_diff;

    public WeightOptimization(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "performance of the last evaluated weight"){

            public double getDoubleValue() {
                return WeightOptimization.this.lastperf;
            }
        });
        this.addValue(new ValueDouble("best_performance", "best performance"){

            public double getDoubleValue() {
                if (WeightOptimization.this.best != null) {
                    return WeightOptimization.this.best.getPerformance().getMainCriterion().getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue(new ValueDouble("weight", "currently used weight"){

            public double getDoubleValue() {
                return WeightOptimization.this.lastweight;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        input.get(ExampleSet.class).clone();
        AttributeWeights attweights = input.get(AttributeWeights.class);
        Object[] names = attweights.getAttributeNames().toArray();
        this.weights = new double[names.length];
        int i = 0;
        while (i < names.length) {
            this.weights[i] = Math.abs(attweights.getWeight((String)names[i]));
            ++i;
        }
        Arrays.sort(this.weights);
        int direction = this.getParameterAsInt(PARAMETER_SELECTION_DIRECTION);
        int max_iter_without_improvement = this.getParameterAsInt(PARAMETER_ITERATIONS_WITHOUT_IMPROVEMENT);
        this.getParametersToOptimize();
        this.operator.getParameters().setParameter("weight_relation", "greater equals");
        int weightindex = this.weights.length - 1;
        if (direction == 1) {
            weightindex = 0;
        }
        this.lastweight = Double.POSITIVE_INFINITY;
        this.lastperf = Double.NaN;
        this.bestweight = this.currentweight = this.weights[weightindex];
        this.best = null;
        int iter = 0;
        int iter_without_improvement = 0;
        while (true) {
            this.log("Iteration: " + ++iter);
            this.log("Using weight");
            this.operator.getParameters().setParameter(this.parameter, Double.toString(this.currentweight));
            this.log(this.operator + "." + this.parameter + " = " + this.currentweight);
            this.log("Number attributes: " + (this.weights.length - weightindex));
            IOContainer container = input.copy();
            int i2 = 0;
            while (i2 < this.getNumberOfOperators()) {
                container = this.getOperator(i2).apply(container);
                ++i2;
            }
            if (!container.contains(PerformanceVector.class)) {
                throw new OperatorException("Cannot find PerformanceVector!");
            }
            PerformanceVector performance = container.get(PerformanceVector.class);
            this.lastperf = performance.getMainCriterion().getFitness();
            this.log("Performance: " + performance.toResultString());
            if (this.best == null || performance.compareTo(this.best.getPerformance()) > 0) {
                String bestValue = Double.toString(this.currentweight);
                this.bestweight = this.currentweight;
                this.best = new ParameterSet(new Operator[]{this.operator}, new String[]{this.parameter}, new String[]{bestValue}, performance);
                iter_without_improvement = 0;
            } else {
                ++iter_without_improvement;
            }
            if (iter_without_improvement >= max_iter_without_improvement) break;
            if (direction == 0 && weightindex == 0 || direction == 1 && weightindex == names.length - 1) {
                this.inApplyLoop();
                break;
            }
            weightindex = direction == 0 ? --weightindex : ++weightindex;
            this.lastweight = this.currentweight;
            this.currentweight = this.weights[weightindex];
            while (Math.abs(this.currentweight - this.lastweight) < this.min_diff) {
                if (weightindex == 0) {
                    this.inApplyLoop();
                    break;
                }
                weightindex = direction == 0 ? --weightindex : ++weightindex;
                this.lastweight = this.currentweight;
                this.currentweight = this.weights[weightindex];
            }
            this.inApplyLoop();
        }
        int i3 = 0;
        while (i3 < names.length) {
            double w = attweights.getWeight((String)names[i3]);
            if (w < this.bestweight) {
                attweights.setWeight((String)names[i3], 0.0);
            }
            ++i3;
        }
        input.remove(AttributeWeights.class);
        return new IOObject[]{this.best, this.best.getPerformance(), attweights};
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public void getParametersToOptimize() throws OperatorException {
        this.min_diff = this.getParameterAsDouble(PARAMETER_MIN_DIFF);
        String keyvalue = this.getParameterAsString(PARAMETER_PARAMETER);
        String[] parameter = keyvalue.split("\\.");
        if (parameter.length < 2 || parameter.length > 3) {
            throw new UserError((Operator)this, 907, keyvalue);
        }
        this.operator = this.getProcess().getOperator(parameter[0]);
        if (this.operator == null) {
            throw new UserError((Operator)this, 109, parameter[0]);
        }
        ParameterType targetType = this.operator.getParameters().getParameterType(parameter[1]);
        this.parameter = parameter[1];
        if (targetType == null) {
            throw new UserError((Operator)this, 906, String.valueOf(parameter[0]) + "." + parameter[1]);
        }
        if (!(targetType instanceof ParameterTypeNumber)) {
            throw new UserError((Operator)this, 909, String.valueOf(parameter[0]) + "." + parameter[1]);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_PARAMETER, "The parameter to set the weight value");
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_SELECTION_DIRECTION, "Forward selection or backward elimination.", DIRECTIONS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_DIFF, "The minimum difference between two weights.", 0.0, Double.POSITIVE_INFINITY, 1.0E-10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_ITERATIONS_WITHOUT_IMPROVEMENT, "Number iterations without performance improvement.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

