/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.condition;

import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.tools.Tools;

public class SpecificInnerOperatorCondition
implements InnerOperatorCondition {
    private String name;
    private int index;
    private Class[] willGet;
    private Class[] mustDeliver;

    public SpecificInnerOperatorCondition(String name, int index, Class[] willGet, Class[] mustDeliver) {
        this.name = name;
        this.index = index;
        this.willGet = willGet;
        this.mustDeliver = mustDeliver;
    }

    public Class[] checkIO(OperatorChain chain, Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (this.index < 0 || this.index >= chain.getNumberOfOperators()) {
            throw new WrongNumberOfInnerOperatorsException(chain, chain.getMinNumberOfInnerOperators(), chain.getMaxNumberOfInnerOperators(), this.index);
        }
        Operator operator = chain.getOperator(this.index);
        if (this.index == 0) {
            Class[] classArray = this.willGet;
            int n = this.willGet.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                if (!DefaultIODescription.containsClass(c, input)) {
                    throw new IllegalInputException(operator, c);
                }
                ++n2;
            }
        }
        Class<?>[] output = operator.checkIO(this.willGet);
        int i = 0;
        while (i < this.mustDeliver.length) {
            if (!DefaultIODescription.containsClass(this.mustDeliver[i], output)) {
                throw new IllegalInputException(chain, operator, this.mustDeliver[i]);
            }
            ++i;
        }
        return this.mustDeliver;
    }

    public String toHTML() {
        StringBuffer result = new StringBuffer("Operator " + (this.index + 1) + " (" + this.name + ") must be able to handle [");
        int i = 0;
        while (i < this.willGet.length) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(Tools.classNameWOPackage(this.willGet[i]));
            ++i;
        }
        result.append("]");
        if (this.mustDeliver != null && this.mustDeliver.length > 0) {
            result.append(" and must deliver [");
            i = 0;
            while (i < this.mustDeliver.length) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(Tools.classNameWOPackage(this.mustDeliver[i]));
                ++i;
            }
            result.append("].");
        } else {
            result.append(".");
        }
        return result.toString();
    }
}

