/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.AbstractClusterer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomClustering
extends AbstractClusterer {
    public static final String PARAMETER_ADD_CLUSTER_ATTRIBUTE = "add_cluster_attribute";
    public static final String PARAMETER_NUMBER_OF_CLUSTERS = "number_of_clusters";

    public RandomClustering(OperatorDescription description) {
        super(description);
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        Tools.checkAndCreateIds(exampleSet);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        int[] clusterAssignments = new int[exampleSet.size()];
        int k = this.getParameterAsInt(PARAMETER_NUMBER_OF_CLUSTERS);
        int i = 0;
        while (i < exampleSet.size()) {
            clusterAssignments[i] = random.nextInt(k);
            ++i;
        }
        ClusterModel model = new ClusterModel(k);
        model.setClusterAssignments(clusterAssignments, exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE) && this.getParameterAsBoolean("keep_example_set")) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i2 = 0;
            for (Example example : exampleSet) {
                example.setValue(cluster, "cluster_" + clusterAssignments[i2]);
                ++i2;
            }
        }
        return model;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE, "Indicates if a cluster id is generated as new special attribute.", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, "keep_example_set", false, true));
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_CLUSTERS, "Specifies the desired number of clusters.", 2, Integer.MAX_VALUE, 3));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }
}

