/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOperator
extends Operator {
    public static final String PARAMETER_COMMAND = "command";
    public static final String PARAMETER_LOG_STDOUT = "log_stdout";
    public static final String PARAMETER_LOG_STDERR = "log_stderr";
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[0];

    public CommandLineOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String command = this.getParameterAsString(PARAMETER_COMMAND);
        boolean logOut = this.getParameterAsBoolean(PARAMETER_LOG_STDOUT);
        boolean logErr = this.getParameterAsBoolean(PARAMETER_LOG_STDERR);
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (logErr) {
                this.logOutput("stderr:", process.getErrorStream());
            }
            if (logOut) {
                this.logOutput("stdout:", process.getInputStream());
            }
            Tools.waitForProcess(this, process, command);
            this.log("Program exited succesfully.");
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 310, command, e.getMessage());
        }
        return new IOObject[0];
    }

    private void logOutput(String message, InputStream in) throws IOException {
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        String line = null;
        StringBuffer buffer = new StringBuffer(message);
        while ((line = bin.readLine()) != null) {
            buffer.append(Tools.getLineSeparator());
            buffer.append(line);
        }
        this.logNote(buffer.toString());
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_COMMAND, "Command to execute.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_LOG_STDOUT, "If set to true, the stdout stream of the command is redirected to the logfile.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_LOG_STDERR, "If set to true, the stderr stream of the command is redirected to the logfile.", true));
        return types;
    }
}

