/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.HTMLEditor;
import com.rapidminer.gui.tools.JavaEditor;
import com.rapidminer.gui.tools.PlainTextEditor;
import com.rapidminer.gui.tools.SQLEditor;
import com.rapidminer.gui.tools.XMLEditor;
import com.rapidminer.gui.tools.syntax.JEditTextArea;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class TextPropertyDialog
extends JDialog {
    private static final long serialVersionUID = 8574310060170861505L;
    private String text = null;
    private boolean ok = false;
    private JEditTextArea textArea = null;

    public TextPropertyDialog(ParameterTypeText type, String text, Operator operator) {
        super(RapidMinerGUI.getMainFrame(), "Text Editor for '" + type.getKey() + "'", true);
        this.text = text;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextPropertyDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextPropertyDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.textArea = this.createTextArea(type.getTextType());
        this.textArea.setText(this.text);
        this.getContentPane().add((Component)this.textArea, "Center");
        this.setSize((int)(0.8 * (double)RapidMinerGUI.getMainFrame().getWidth()), (int)(0.8 * (double)RapidMinerGUI.getMainFrame().getHeight()));
        this.setLocationRelativeTo(RapidMinerGUI.getMainFrame());
    }

    private void ok() {
        this.ok = true;
        this.text = this.textArea.getText();
        this.dispose();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getText() {
        return this.text;
    }

    private JEditTextArea createTextArea(TextType type) {
        switch (type) {
            case PLAIN: {
                return new PlainTextEditor();
            }
            case XML: {
                return new XMLEditor();
            }
            case HTML: {
                return new HTMLEditor();
            }
            case SQL: {
                return new SQLEditor();
            }
            case JAVA: {
                return new JavaEditor();
            }
        }
        return new PlainTextEditor();
    }
}

