/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.borders.Borders;
import com.rapidminer.gui.look.fc.FileList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class FileChooserUI
extends BasicFileChooserUI {
    public static final String FILECHOOSER_VIEW_TYPE = "FILECHOOSER_VIEW_TYPE";
    public static final String FILECHOOSER_VIEW_THUMBNAIL = "Thumbnails";
    public static final String FILECHOOSER_VIEW_ICON = "Icons";
    public static final String FILECHOOSER_VIEW_LIST = "List";
    public static final String FILECHOOSER_VIEW_DETAILS = "Details";
    private static Border buttonsEmptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static File userHomeDirectory;
    private static final int INDENT_SPACE = 10;
    private static final Dimension HORIZONTAL_STRUT_5;
    private static final Dimension HORIZONTAL_STRUT_15;
    private static final Dimension VERTICAL_STRUT_5;
    private static final Insets NO_MARGIN;
    private ButtonGroup changeViewButtonGroup;
    public String viewType = "Details";
    private Action goToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private Action goBackAction = new GoBackAction();
    protected Vector<String> backPathVector = new Vector();
    protected JButton bookmarksButton;
    private JPopupMenu changeViewPopup;
    private Icon changeViewNormal = null;
    private Icon changeViewHighlighted = null;
    private Icon bookmarksAddNormal = null;
    private Icon bookmarksAddHighlighted = null;
    private Icon homeNormal = null;
    private Icon homeHighlighted = null;
    private Icon homeDisabled = null;
    private Icon newFolderNormal = null;
    private Icon newFolderHighlighted = null;
    private Icon newFolderDisabled = null;
    private Icon upFolderNormal = null;
    private Icon upFolderHighlighted = null;
    private Icon upFolderDisabled = null;
    private Icon backNormal = null;
    private Icon backHighlighted = null;
    private Icon backDisabled = null;
    private final Border roundComboboxListRendererBorder = Borders.getComboBoxListCellRendererFocusBorder();
    private JToggleButton changeViewButton;
    protected FileList fileList;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String backButtonToolTipText = "Go to Previous Folder Visited";
    private String backButtonAccessibleName = " ";
    private BasicFileChooserUI.BasicFileView fileView = new RapidLookFileView();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action approveSelectionAction = new ExtendedApproveSelectionAction();

    static {
        HORIZONTAL_STRUT_5 = new Dimension(5, 5);
        HORIZONTAL_STRUT_15 = new Dimension(15, 15);
        VERTICAL_STRUT_5 = new Dimension(1, 5);
        NO_MARGIN = new Insets(0, 0, 0, 0);
    }

    protected ActionMap createActions() {
        AbstractAction escAction = new AbstractAction(){
            private static final long serialVersionUID = -3976059968191425942L;

            public void actionPerformed(ActionEvent e) {
                FileChooserUI.this.fileList.stopTumbnailGeneration();
                FileChooserUI.this.getFileChooser().cancelSelection();
            }

            public boolean isEnabled() {
                return FileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        return map;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public String getView() {
        return this.viewType;
    }

    public static ComponentUI createUI(JComponent c) {
        return new FileChooserUI((JFileChooser)c);
    }

    public FileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
        this.fileList = null;
        super.uninstallComponents(fc);
    }

    public void installIcons(JFileChooser fc) {
        super.installIcons(fc);
        this.changeViewNormal = UIManager.getIcon("FileChooser.ChangeViewNormalIcon");
        this.changeViewHighlighted = UIManager.getIcon("FileChooser.ChangeViewHighlightedIcon");
        this.bookmarksAddNormal = UIManager.getIcon("FileChooser.BookmarksAddNormalIcon");
        this.bookmarksAddHighlighted = UIManager.getIcon("FileChooser.BookmarksAddHighlightedIcon");
        this.homeNormal = UIManager.getIcon("FileChooser.HomeNormalIcon");
        this.homeHighlighted = UIManager.getIcon("FileChooser.HomeHighlightedIcon");
        this.homeDisabled = UIManager.getIcon("FileChooser.HomeDisabledIcon");
        this.newFolderNormal = UIManager.getIcon("FileChooser.NewFolderNormalIcon");
        this.newFolderHighlighted = UIManager.getIcon("FileChooser.NewFolderHighlightedIcon");
        this.newFolderDisabled = UIManager.getIcon("FileChooser.NewFolderDisabledIcon");
        this.upFolderNormal = UIManager.getIcon("FileChooser.UpFolderNormalIcon");
        this.upFolderHighlighted = UIManager.getIcon("FileChooser.UpFolderHighlightedIcon");
        this.upFolderDisabled = UIManager.getIcon("FileChooser.UpFolderDisabledIcon");
        this.backNormal = UIManager.getIcon("FileChooser.BackFolderNormalIcon");
        this.backHighlighted = UIManager.getIcon("FileChooser.BackFolderHighlightedIcon");
        this.backDisabled = UIManager.getIcon("FileChooser.BackFolderDisabledIcon");
    }

    protected void uninstallIcons(JFileChooser fc) {
        super.uninstallIcons(fc);
        this.changeViewNormal = null;
        this.changeViewHighlighted = null;
        this.bookmarksAddNormal = null;
        this.bookmarksAddHighlighted = null;
        this.homeNormal = null;
        this.homeHighlighted = null;
        this.homeDisabled = null;
        this.newFolderNormal = null;
        this.newFolderHighlighted = null;
        this.newFolderDisabled = null;
        this.upFolderNormal = null;
        this.upFolderHighlighted = null;
        this.upFolderDisabled = null;
        this.backNormal = null;
        this.backHighlighted = null;
        this.backDisabled = null;
    }

    public void installComponents(JFileChooser fc) {
        FileSystemView fsv = fc.getFileSystemView();
        userHomeDirectory = fsv.getHomeDirectory();
        this.changeViewPopup = this.createViewPopupMenu();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        JToolBar topPanel = new JToolBar();
        topPanel.setFloatable(false);
        topPanel.setBorder(null);
        topPanel.setOpaque(false);
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.setOpaque(false);
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setMaximumRowCount(9);
        this.directoryComboBox.setMaximumSize(new Dimension((int)this.directoryComboBox.getMaximumSize().getWidth(), 27));
        topPanel.add((Component)this.directoryComboBox, "Center");
        topPanel.add(Box.createRigidArea(HORIZONTAL_STRUT_15));
        JButton backButton = new JButton(this.getGoBackAction());
        backButton.setText(null);
        backButton.setRolloverEnabled(true);
        backButton.setIcon(this.backNormal);
        backButton.setPressedIcon(this.backHighlighted);
        backButton.setRolloverIcon(this.backHighlighted);
        backButton.setDisabledIcon(this.backDisabled);
        backButton.setToolTipText(this.backButtonToolTipText);
        backButton.getAccessibleContext().setAccessibleName(this.backButtonAccessibleName);
        backButton.setBorder(buttonsEmptyBorder);
        backButton.setAlignmentX(0.0f);
        backButton.setAlignmentY(0.5f);
        backButton.setMargin(NO_MARGIN);
        backButton.setBackground((Color)UIManager.get("control"));
        backButton.setOpaque(false);
        backButton.setFocusable(false);
        topPanel.add(backButton);
        topPanel.add(Box.createRigidArea(HORIZONTAL_STRUT_5));
        JButton upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        upFolderButton.setText(null);
        upFolderButton.setRolloverEnabled(true);
        upFolderButton.setIcon(this.upFolderNormal);
        upFolderButton.setPressedIcon(this.upFolderHighlighted);
        upFolderButton.setRolloverIcon(this.upFolderHighlighted);
        upFolderButton.setDisabledIcon(this.upFolderDisabled);
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        upFolderButton.setBorder(buttonsEmptyBorder);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(NO_MARGIN);
        upFolderButton.setBackground((Color)UIManager.get("control"));
        upFolderButton.setFocusable(false);
        upFolderButton.setOpaque(false);
        topPanel.add(upFolderButton);
        topPanel.add(Box.createRigidArea(HORIZONTAL_STRUT_5));
        this.bookmarksButton = new JButton(new BookmarkAction());
        this.bookmarksButton.setRolloverEnabled(true);
        this.bookmarksButton.setOpaque(false);
        this.bookmarksButton.setIcon(this.bookmarksAddNormal);
        this.bookmarksButton.setPressedIcon(this.bookmarksAddHighlighted);
        this.bookmarksButton.setRolloverIcon(this.bookmarksAddHighlighted);
        this.bookmarksButton.setBorder(buttonsEmptyBorder);
        this.bookmarksButton.setFocusable(false);
        this.bookmarksButton.setToolTipText("Add to Bookmarks");
        this.bookmarksButton.setVisible(true);
        this.bookmarksButton.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        this.bookmarksButton.setAlignmentX(0.0f);
        this.bookmarksButton.setAlignmentY(0.5f);
        this.bookmarksButton.setMargin(NO_MARGIN);
        this.bookmarksButton.setBackground((Color)UIManager.get("control"));
        topPanel.add(this.bookmarksButton);
        topPanel.add(Box.createRigidArea(HORIZONTAL_STRUT_5));
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.getGoHomeAction());
        b.setRolloverEnabled(true);
        b.setIcon(this.homeNormal);
        b.setPressedIcon(this.homeHighlighted);
        b.setRolloverIcon(this.homeHighlighted);
        b.setDisabledIcon(this.homeDisabled);
        b.setText("");
        b.setToolTipText(toolTipText);
        b.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(NO_MARGIN);
        b.setBorder(buttonsEmptyBorder);
        b.setFocusable(false);
        b.setOpaque(false);
        topPanel.add(b);
        topPanel.add(Box.createRigidArea(HORIZONTAL_STRUT_5));
        b = new JButton(this.getNewFolderAction());
        b.setText(null);
        b.setRolloverEnabled(true);
        b.setIcon(this.newFolderNormal);
        b.setPressedIcon(this.newFolderHighlighted);
        b.setRolloverIcon(this.newFolderHighlighted);
        b.setDisabledIcon(this.newFolderDisabled);
        b.setBorder(buttonsEmptyBorder);
        b.setOpaque(false);
        b.setFocusable(false);
        b.setToolTipText(this.newFolderToolTipText);
        b.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(NO_MARGIN);
        topPanel.add(b);
        topPanel.add(Box.createRigidArea(HORIZONTAL_STRUT_5));
        this.changeViewButton = new JToggleButton(new ChangeViewAction());
        this.changeViewButton.setText(null);
        this.changeViewButton.setRolloverEnabled(true);
        this.changeViewButton.setIcon(this.changeViewNormal);
        this.changeViewButton.setPressedIcon(this.changeViewHighlighted);
        this.changeViewButton.setRolloverIcon(this.changeViewHighlighted);
        this.changeViewButton.setSelectedIcon(this.changeViewHighlighted);
        this.changeViewButton.setToolTipText("Change view");
        this.changeViewButton.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        this.changeViewButton.setAlignmentX(0.0f);
        this.changeViewButton.setAlignmentY(0.5f);
        this.changeViewButton.setMargin(NO_MARGIN);
        this.changeViewButton.setBackground((Color)UIManager.get("control"));
        this.changeViewButton.setBorder(buttonsEmptyBorder);
        this.changeViewButton.setOpaque(false);
        this.changeViewButton.setFocusable(false);
        topPanel.add(this.changeViewButton);
        topPanel.add(Box.createRigidArea(HORIZONTAL_STRUT_5));
        topPanel.setBackground((Color)UIManager.get("control"));
        this.fileList = new FileList(this, fc);
        fc.addPropertyChangeListener(this.fileList);
        this.fileList.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc.add((Component)this.fileList, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        fc.add((Component)bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setOpaque(false);
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(VERTICAL_STRUT_5));
        AlignedLabel fileNameLabel = new AlignedLabel(this.fileNameLabelText);
        fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fileNamePanel.add(fileNameLabel);
        this.fileNameTextField = new JTextField();
        fileNamePanel.add(this.fileNameTextField);
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setOpaque(false);
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.setOpaque(false);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.setOpaque(false);
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setOpaque(false);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        FileChooserUI.groupLabels(new AlignedLabel[]{fileNameLabel, filesOfTypeLabel});
    }

    public Action getNewFolderAction() {
        NewFolderAction newFolderAction = new NewFolderAction();
        if (UIManager.getBoolean("FileChooser.readOnly")) {
            newFolderAction.setEnabled(false);
        }
        return newFolderAction;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setOpaque(false);
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.changeViewPopup.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().toLowerCase().equals("visible")) {
                    FileChooserUI.this.changeViewButton.setSelected(Boolean.parseBoolean(e.getNewValue().toString()));
                }
            }
        });
        ActionMap actionMap = this.getActions();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActions() {
        return this.createActions();
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void setFileSelected() {
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (files != null && i < files.length) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length > 1) {
                buf.append("\"");
            }
            ++i;
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        } else {
            this.setFileName("");
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        this.fileList.updatePath(currentDirectory);
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            this.getGoHomeAction().setEnabled(!userHomeDirectory.equals(currentDirectory));
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.fileList.doFilterChanged();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.doFilterChanged(e);
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (!this.getFileChooser().isMultiSelectionEnabled()) {
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    FileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    FileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    FileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    FileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    FileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    FileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    FileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    FileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    FileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    FileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    FileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("FileHidingChanged")) {
                    FileChooserUI.this.fileList.doFilterChanged();
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    FileChooserUI.this.fileNameTextField.selectAll();
                    FileChooserUI.this.fileList.itemPanel.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.fileList.rescanDirectory();
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected void setCurrentDirectoryOfFileChooser(File f) {
        this.getFileChooser().setCurrentDirectory(f);
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] group) {
        AlignedLabel[] alignedLabelArray = group;
        int n = group.length;
        int n2 = 0;
        while (n2 < n) {
            AlignedLabel element = alignedLabelArray[n2];
            element.group = group;
            ++n2;
        }
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    public void goBack() {
        if (this.backPathVector.size() > 0) {
            this.setCurrentDirectoryOfFileChooser(new File(this.backPathVector.elementAt(this.backPathVector.size() - 1)));
            if (this.backPathVector.size() > 1) {
                this.backPathVector.setSize(this.backPathVector.size() - 2);
            } else {
                this.backPathVector.setSize(this.backPathVector.size() - 1);
            }
            if (this.backPathVector.size() <= 0) {
                this.getGoBackAction().setEnabled(false);
            }
        }
    }

    public Action getGoBackAction() {
        return this.goBackAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.goToParentDirectoryAction;
    }

    public JPopupMenu createViewPopupMenu() {
        changeViewActionListener mal = new changeViewActionListener();
        this.changeViewPopup = new JPopupMenu();
        this.changeViewButtonGroup = new ButtonGroup();
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(FILECHOOSER_VIEW_THUMBNAIL);
        this.changeViewButtonGroup.add(menuItem);
        menuItem.setActionCommand(FILECHOOSER_VIEW_THUMBNAIL);
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem(FILECHOOSER_VIEW_ICON);
        menuItem.setActionCommand(FILECHOOSER_VIEW_ICON);
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem(FILECHOOSER_VIEW_LIST);
        menuItem.setActionCommand(FILECHOOSER_VIEW_LIST);
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        menuItem.setSelected(true);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem(FILECHOOSER_VIEW_DETAILS);
        menuItem.setActionCommand(FILECHOOSER_VIEW_DETAILS);
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        return this.changeViewPopup;
    }

    protected void updateView(String s) {
        if (!(s.equals(FILECHOOSER_VIEW_DETAILS) || s.equals(FILECHOOSER_VIEW_ICON) || s.equals(FILECHOOSER_VIEW_LIST) || s.equals(FILECHOOSER_VIEW_THUMBNAIL))) {
            return;
        }
        this.viewType = s;
        this.fileList.changeCardForView();
        Enumeration<AbstractButton> en = this.changeViewButtonGroup.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbm = (JRadioButtonMenuItem)en.nextElement();
            if (!rbm.getActionCommand().equals(this.getView())) continue;
            this.changeViewButtonGroup.setSelected(rbm.getModel(), true);
        }
    }

    private class AlignedLabel
    extends JLabel {
        private static final long serialVersionUID = 4912090609095372381L;
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel(String text) {
            super(text);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth(), d.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                AlignedLabel element;
                int max = 0;
                AlignedLabel[] alignedLabelArray = this.group;
                int n = this.group.length;
                int n2 = 0;
                while (n2 < n) {
                    element = alignedLabelArray[n2];
                    max = Math.max(element.getSuperPreferredWidth(), max);
                    ++n2;
                }
                alignedLabelArray = this.group;
                n = this.group.length;
                n2 = 0;
                while (n2 < n) {
                    element = alignedLabelArray[n2];
                    element.maxWidth = max;
                    ++n2;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            if (this.getText() == null) {
                return super.getPreferredSize().width;
            }
            return super.getPreferredSize().width + 11;
        }
    }

    private class BookmarkAction
    extends AbstractAction {
        private static final long serialVersionUID = -654304868192207741L;

        private BookmarkAction() {
        }

        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.fileList.addToBookmarks();
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int horizontalGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        public void addLayoutComponent(String string, Component comp) {
        }

        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                int counter = 0;
                while (counter < numChildren) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                    ++counter;
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    xOffset = this.horizontalGap + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(this.horizontalGap + maxWidth);
                }
                int counter2 = numChildren - 1;
                while (counter2 >= 0) {
                    children[counter2].setBounds(xLocation, yLocation, maxWidth, sizes[counter2].height);
                    xLocation -= xOffset;
                    --counter2;
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                int counter = 0;
                while (counter < numChildren) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                    ++counter;
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.horizontalGap, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public void removeLayoutComponent(Component c) {
        }
    }

    private class CancelSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 2080395201063859907L;

        private CancelSelectionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.fileList.stopTumbnailGeneration();
            FileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    private class ChangeToParentDirectoryAction
    extends AbstractAction {
        private static final long serialVersionUID = -3805300411336163058L;

        protected ChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.getFileChooser().changeToParentDirectory();
        }
    }

    private class ChangeViewAction
    extends AbstractAction {
        private static final long serialVersionUID = 6720057807081456009L;

        private ChangeViewAction() {
        }

        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.changeViewPopup.show((JToggleButton)e.getSource(), 0, ((JToggleButton)e.getSource()).getHeight() - 3);
        }
    }

    private class DirectoryComboBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = -6851838331146924117L;

        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            File f = (File)FileChooserUI.this.directoryComboBox.getSelectedItem();
            FileChooserUI.this.setCurrentDirectoryOfFileChooser(f);
            FileChooserUI.this.fileNameTextField.requestFocus();
        }
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = -7566898679781533334L;
        private Vector<File> directories = new Vector();
        private int[] depths = null;
        private File selectedDirectory = null;
        private JFileChooser chooser;
        private FileSystemView fileSystemView;

        public DirectoryComboBoxModel() {
            this.chooser = FileChooserUI.this.getFileChooser();
            this.fileSystemView = this.chooser.getFileSystemView();
            File dir = FileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = this.fileSystemView.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                ShellFolder sf;
                File f = sf = ShellFolder.getShellFolder(canonical);
                Vector<ShellFolder> path = new Vector<ShellFolder>(10);
                do {
                    path.addElement((ShellFolder)f);
                } while ((f = ((File)f).getParentFile()) != null);
                int pathCount = path.size();
                int i = 0;
                while (i < pathCount) {
                    f = (File)path.get(i);
                    if (this.directories.contains(f)) {
                        int topIndex = this.directories.indexOf(f);
                        int j = i - 1;
                        while (j >= 0) {
                            this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                            --j;
                        }
                        break;
                    }
                    ++i;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            int i = 0;
            while (i < this.depths.length) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent != null) {
                    int j = i - 1;
                    while (j >= 0) {
                        if (parent.equals(this.directories.get(j))) {
                            this.depths[i] = this.depths[j] + 1;
                            break;
                        }
                        --j;
                    }
                }
                ++i;
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    private class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4597909127976297943L;
        private IndentIcon indentIcon = new IndentIcon();

        private DirectoryComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(FileChooserUI.this.getFileChooser().getName(directory));
            Icon icon = FileChooserUI.this.getFileChooser().getIcon(directory);
            if (icon == null) {
                icon = UIManager.getIcon("FileChooser.defaultDirectoryIcon");
            }
            this.indentIcon.icon = icon;
            this.indentIcon.depth = FileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.indentIcon);
            if (isSelected && index > -1) {
                this.setBorder(FileChooserUI.this.roundComboboxListRendererBorder);
            }
            return this;
        }
    }

    private class ExtendedApproveSelectionAction
    extends BasicFileChooserUI.ApproveSelectionAction {
        private static final long serialVersionUID = 4061933557078579689L;

        private ExtendedApproveSelectionAction() {
            super(FileChooserUI.this);
        }

        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.fileList.stopTumbnailGeneration();
            super.actionPerformed(e);
        }
    }

    private class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private static final long serialVersionUID = -7578988904254755349L;
        private FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = FileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                FileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                FileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = FileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                FileFilter[] fileFilterArray = this.filters;
                int n = this.filters.length;
                int n2 = 0;
                while (n2 < n) {
                    FileFilter element = fileFilterArray[n2];
                    if (element == currentFilter) {
                        found = true;
                    }
                    ++n2;
                }
                if (!found) {
                    FileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return FileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return FileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    private class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 7024419790190737084L;

        private FilterComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            if (isSelected && index > -1) {
                this.setBorder(FileChooserUI.this.roundComboboxListRendererBorder);
            }
            return this;
        }
    }

    private class GoBackAction
    extends AbstractAction {
        private static final long serialVersionUID = 5132122622014626886L;

        protected GoBackAction() {
            super("Go Back");
        }

        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.goBack();
        }
    }

    private static class IndentIcon
    implements Icon {
        private Icon icon;
        private int depth = 0;

        private IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(c, g, x + this.depth * 10, y);
                } else {
                    this.icon.paintIcon(c, g, x, y);
                }
            }
        }

        public int getIconWidth() {
            if (this.icon == null) {
                return this.depth * 10;
            }
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            if (this.icon == null) {
                return 0;
            }
            return this.icon.getIconHeight();
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        private static final long serialVersionUID = -119998626996460617L;

        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent e) {
            if (UIManager.getBoolean("FileChooser.readOnly")) {
                return;
            }
            JFileChooser fc = FileChooserUI.this.getFileChooser();
            File currentDirectory = fc.getCurrentDirectory();
            File newFolder = null;
            String name = JOptionPane.showInputDialog(FileChooserUI.this.getFileChooser(), (Object)"Please insert the name of the new folder:");
            try {
                if (name != null || !name.equals("")) {
                    newFolder = fc.getFileSystemView().createNewFolder(currentDirectory);
                    if (newFolder.renameTo(new File(newFolder.getParentFile(), name))) {
                        newFolder = new File(newFolder.getParentFile(), name);
                    } else {
                        JOptionPane.showConfirmDialog(FileChooserUI.this.getFileChooser(), "An error occured while renaming the new folder.", "Create Folder", -1, 0);
                    }
                }
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(fc, "Cannot create new folder: " + exc, "Error", 0);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(new File[]{newFolder});
            } else {
                fc.setSelectedFile(newFolder);
            }
            fc.rescanCurrentDirectory();
        }
    }

    private class RapidLookFileView
    extends BasicFileChooserUI.BasicFileView {
        private RapidLookFileView() {
            super(FileChooserUI.this);
        }

        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (f != null) {
                icon = FileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f);
            }
            if (icon == null) {
                icon = super.getIcon(f);
            }
            this.cacheIcon(f, icon);
            return icon;
        }
    }

    private class changeViewActionListener
    implements ActionListener {
        private changeViewActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.updateView(e.getActionCommand());
        }
    }
}

