/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeDescription;
import com.rapidminer.example.AttributeTransformation;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Statistics;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.tools.Ontology;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttribute
implements Attribute {
    private static final long serialVersionUID = -9167755945651618227L;
    private transient List<Attributes> owners = new LinkedList<Attributes>();
    private AttributeDescription attributeDescription;
    private final LinkedList<AttributeTransformation> transformations = new LinkedList();
    private List<Statistics> statistics = new LinkedList<Statistics>();
    private String constructionDescription = null;

    AbstractAttribute(AbstractAttribute attribute) {
        this.attributeDescription = attribute.attributeDescription;
        this.statistics = new LinkedList<Statistics>();
        for (Statistics statistics : attribute.statistics) {
            this.statistics.add((Statistics)statistics.clone());
        }
        int counter = 0;
        for (AttributeTransformation transformation : attribute.transformations) {
            if (counter < attribute.transformations.size() - 1) {
                this.addTransformation(transformation);
            } else {
                this.addTransformation((AttributeTransformation)transformation.clone());
            }
            ++counter;
        }
        this.constructionDescription = attribute.constructionDescription;
    }

    AbstractAttribute(String name, int valueType) {
        this.attributeDescription = new AttributeDescription(this, name, valueType, 1, 0.0, -1);
        this.constructionDescription = name;
    }

    public Object readResolve() {
        if (this.owners == null) {
            this.owners = new LinkedList<Attributes>();
        }
        return this;
    }

    @Override
    public void addOwner(Attributes attributes) {
        this.owners.add(attributes);
    }

    @Override
    public void removeOwner(Attributes attributes) {
        this.owners.remove(attributes);
    }

    @Override
    public abstract Object clone();

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AbstractAttribute)) {
            return false;
        }
        AbstractAttribute a = (AbstractAttribute)o;
        return this.attributeDescription.equals(a.attributeDescription);
    }

    @Override
    public int hashCode() {
        return this.attributeDescription.hashCode();
    }

    @Override
    public void addTransformation(AttributeTransformation transformation) {
        this.transformations.add(transformation);
    }

    @Override
    public void clearTransformations() {
        this.transformations.clear();
    }

    @Override
    public AttributeTransformation getLastTransformation() {
        if (this.transformations.size() > 0) {
            return this.transformations.getLast();
        }
        return null;
    }

    @Override
    public double getValue(DataRow row) {
        double tableValue;
        double result = tableValue = row.get(this.getTableIndex(), this.getDefault());
        for (AttributeTransformation transformation : this.transformations) {
            result = transformation.transform(this, result);
        }
        return result;
    }

    @Override
    public void setValue(DataRow row, double value) {
        double newValue = value;
        for (AttributeTransformation transformation : this.transformations) {
            if (transformation.isReversable()) {
                newValue = transformation.inverseTransform(this, newValue);
                continue;
            }
            throw new RuntimeException("Cannot set value for attribute using irreversible transformations. This process will probably work if you deactivate create_view in preprocessing operators.");
        }
        row.set(this.getTableIndex(), newValue, this.getDefault());
    }

    @Override
    public String getName() {
        return this.attributeDescription.getName();
    }

    @Override
    public void setName(String v) {
        if (v.equals(this.attributeDescription.getName())) {
            return;
        }
        for (Attributes attributes : this.owners) {
            attributes.rename(this, v);
        }
        this.attributeDescription = (AttributeDescription)this.attributeDescription.clone();
        this.attributeDescription.setName(v);
    }

    @Override
    public int getTableIndex() {
        return this.attributeDescription.getTableIndex();
    }

    @Override
    public void setTableIndex(int i) {
        this.attributeDescription = (AttributeDescription)this.attributeDescription.clone();
        this.attributeDescription.setTableIndex(i);
    }

    @Override
    public int getBlockType() {
        return this.attributeDescription.getBlockType();
    }

    @Override
    public void setBlockType(int b) {
        this.attributeDescription = (AttributeDescription)this.attributeDescription.clone();
        this.attributeDescription.setBlockType(b);
    }

    @Override
    public int getValueType() {
        return this.attributeDescription.getValueType();
    }

    @Override
    public Iterator<Statistics> getAllStatistics() {
        return this.statistics.iterator();
    }

    @Override
    public void registerStatistics(Statistics statistics) {
        this.statistics.add(statistics);
    }

    @Override
    @Deprecated
    public double getStatistics(String name) {
        return this.getStatistics(name, null);
    }

    @Override
    @Deprecated
    public double getStatistics(String name, String parameter) {
        for (Statistics statistics : this.statistics) {
            if (!statistics.handleStatistics(name)) continue;
            return statistics.getStatistics(this, name, parameter);
        }
        throw new RuntimeException("No statistics object was available for attribute statistics '" + name + "'!");
    }

    @Override
    public String getConstruction() {
        return this.constructionDescription;
    }

    @Override
    public void setConstruction(String description) {
        this.constructionDescription = description;
    }

    @Override
    public void setDefault(double value) {
        this.attributeDescription = (AttributeDescription)this.attributeDescription.clone();
        this.attributeDescription.setDefault(value);
    }

    @Override
    public double getDefault() {
        return this.attributeDescription.getDefault();
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("#");
        result.append(this.attributeDescription.getTableIndex());
        result.append(": ");
        result.append(this.attributeDescription.getName());
        result.append(" (");
        result.append(Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.attributeDescription.getValueType()));
        result.append("/");
        result.append(Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(this.attributeDescription.getBlockType()));
        result.append(")");
        return result.toString();
    }
}

