/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.DoubleSparseArrayDataRow;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.RapidMinerOutputFilter;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.FeatureExtractor;
import com.rapidminer.tools.LoggingHandler;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTWordVector;
import edu.udo.cs.wvtool.wordlist.WVTWordList;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExampleTableOutputFilter
implements RapidMinerOutputFilter {
    public static final int ID_TYPE_LONG = 0;
    public static final int ID_TYPE_SHORT = 1;
    public static final int ID_TYPE_NUMERICAL = 2;
    public static final String[] ID_TYPE_NAMES = new String[]{"long", "short", "number"};
    private MemoryExampleTable exampleTable;
    private final List<DataRow> vectors = new LinkedList<DataRow>();
    private final boolean useSpecialAttributes;
    private final int idType;
    private int counter = 1;
    private Attribute[] wordAttributes;
    private Collection<Attribute> extractorAttributes;
    private final Attribute idAtt;
    private final Attribute sourceAtt = AttributeFactory.createAttribute((String)"text_source", (int)1);
    private final Attribute typeAtt = AttributeFactory.createAttribute((String)"content_type", (int)1);
    private final Attribute encodingAtt = AttributeFactory.createAttribute((String)"content_encoding", (int)1);
    private final Attribute languageAtt = AttributeFactory.createAttribute((String)"content_language", (int)1);
    private final Attribute labelAtt;
    private final FeatureExtractor extractor;
    private final LoggingHandler logger;
    private final boolean extendExampleSet;
    private ExampleSet exampleSetToExtend;
    private final Map<String, Example> myOwnPrivateIdExampleMap = new HashMap<String, Example>();

    public ExampleTableOutputFilter(Attribute classAttribute, WVTWordList wordList, boolean useSpecialAttributes, int idType, FeatureExtractor extractor, ExampleSet eset, LoggingHandler logger) {
        this.extendExampleSet = eset != null;
        this.exampleSetToExtend = eset;
        this.idType = idType;
        this.logger = logger;
        HashSet<String> attributeNames = new HashSet<String>();
        this.useSpecialAttributes = useSpecialAttributes;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (this.extendExampleSet) {
            this.labelAtt = eset.getAttributes().getLabel();
            this.idAtt = eset.getAttributes().getId();
            if (!this.idAtt.isNominal()) {
                logger.logWarning("The id attribute of the original example set is not nominal. This is likely to produce an error, please use nominal attributes to extend an example set.");
            }
            Iterator it = this.exampleSetToExtend.getAttributes().allAttributes();
            while (it.hasNext()) {
                attributeNames.add(((Attribute)it.next()).getName());
            }
            for (Example e : this.exampleSetToExtend) {
                this.myOwnPrivateIdExampleMap.put(e.getValueAsString(this.idAtt), e);
            }
        } else {
            this.labelAtt = classAttribute != null ? (Attribute)classAttribute.clone() : null;
            this.idAtt = this.idType == 2 ? AttributeFactory.createAttribute((String)"id", (int)3) : AttributeFactory.createAttribute((String)"id", (int)1);
            attributes.add(this.idAtt);
        }
        attributeNames.add(this.idAtt.getName());
        this.extractor = extractor;
        logger.log("Total number of words is " + wordList.getNumWords());
        this.wordAttributes = new Attribute[wordList.getNumWords()];
        if (useSpecialAttributes) {
            attributes.add(this.sourceAtt);
            attributes.add(this.typeAtt);
            attributes.add(this.encodingAtt);
            attributes.add(this.languageAtt);
            attributeNames.add(this.sourceAtt.getName());
            attributeNames.add(this.typeAtt.getName());
            attributeNames.add(this.encodingAtt.getName());
            attributeNames.add(this.languageAtt.getName());
        }
        String labelAttName = "";
        if (this.labelAtt != null) {
            labelAttName = this.labelAtt.getName();
            attributeNames.add(classAttribute.getName());
        }
        int i = 0;
        while (i < this.wordAttributes.length) {
            String attributeName = null;
            if (attributeNames.contains(wordList.getWord(i))) {
                logger.logWarning("The original example example set already contains an attribute named \"" + wordList.getWord(i) + "\". This is likely to cause trouble. Please rename the attribute in the original example set.");
            }
            if (!wordList.getWord(i).equals(labelAttName)) {
                attributeName = wordList.getWord(i);
            } else {
                attributeName = String.valueOf(labelAttName) + "_";
                logger.logWarning("There is a term that equals the class attribute, renaming it");
            }
            attributeNames.add(attributeName);
            Attribute a = AttributeFactory.createAttribute((String)attributeName, (int)4);
            attributes.add(a);
            this.wordAttributes[i] = a;
            ++i;
        }
        if (extractor != null) {
            this.extractorAttributes = extractor.getAttributes();
            Iterator<Attribute> it = this.extractorAttributes.iterator();
            while (it.hasNext()) {
                Attribute att = it.next();
                if (attributeNames.contains(att.getName())) {
                    it.remove();
                    logger.log("The extractor added an attribute with a name that is already used by another attribute: [" + att.getName() + "]. This attribute is omitted. Please rename this attribute and rerun.");
                    continue;
                }
                attributes.add(att);
            }
        } else {
            this.extractorAttributes = new LinkedList<Attribute>();
        }
        if (this.extendExampleSet) {
            this.exampleTable = (MemoryExampleTable)eset.getExampleTable();
            this.exampleTable.addAttributes(attributes);
            for (Attribute att : attributes) {
                this.exampleSetToExtend.getAttributes().addRegular(att);
            }
        } else {
            if (this.labelAtt != null) {
                attributes.add(this.labelAtt);
            }
            this.exampleTable = new MemoryExampleTable(attributes);
        }
    }

    public void write(WVTWordVector wordVector) {
        String sourceName;
        WVTDocumentInfo docInfo = wordVector.getDocumentInfo();
        String idString = sourceName = docInfo.getSourceName();
        if (this.idType == 1) {
            idString = sourceName.substring(sourceName.lastIndexOf(File.separator) + 1);
        }
        if (this.extendExampleSet) {
            Example e = this.myOwnPrivateIdExampleMap.get(idString);
            if (e == null) {
                this.logger.logWarning("Did not find example with id " + idString + ". Please check whether the original example set has the same nominal id type as selected in the operator.");
            } else {
                double[] values = wordVector.getValues();
                int i = 0;
                while (i < values.length) {
                    if (Double.isInfinite(values[i]) || Double.isNaN(values[i])) {
                        e.setValue(this.wordAttributes[i], 0.0);
                    } else {
                        e.setValue(this.wordAttributes[i], values[i]);
                    }
                    ++i;
                }
            }
        } else {
            DoubleSparseArrayDataRow row = new DoubleSparseArrayDataRow(wordVector.getValues().length + this.extractorAttributes.size());
            if (this.idType == 2) {
                row.set(this.idAtt, (double)this.counter++);
            } else {
                row.set(this.idAtt, (double)this.idAtt.getMapping().mapString(idString));
            }
            if (this.useSpecialAttributes) {
                row.set(this.sourceAtt, (double)this.sourceAtt.getMapping().mapString(docInfo.getSourceName()));
                row.set(this.typeAtt, (double)this.typeAtt.getMapping().mapString(docInfo.getContentType()));
                row.set(this.encodingAtt, (double)this.encodingAtt.getMapping().mapString(docInfo.getContentEncoding()));
                row.set(this.languageAtt, (double)this.languageAtt.getMapping().mapString(docInfo.getContentLanguage()));
            }
            if (this.labelAtt != null) {
                row.set(this.labelAtt, (double)docInfo.getClassValue());
            }
            double[] values = wordVector.getValues();
            int i = 0;
            while (i < values.length) {
                if (Double.isInfinite(values[i]) || Double.isNaN(values[i])) {
                    row.set(this.wordAttributes[i], 0.0);
                } else {
                    row.set(this.wordAttributes[i], values[i]);
                }
                ++i;
            }
            try {
                if (this.extractor != null) {
                    this.extractor.extract(docInfo, (DataRow)row);
                }
            }
            catch (ExtractionException e) {
                this.logger.logWarning("Could not extract any values for item '" + sourceName + "':" + e);
            }
            row.trim();
            this.vectors.add((DataRow)row);
        }
    }

    public ExampleSet createExampleSet() throws OperatorException {
        if (this.extendExampleSet) {
            return this.exampleSetToExtend;
        }
        if (this.exampleTable == null) {
            throw new OperatorException("WordVectorTool did not generate word vectors. Please check file names.");
        }
        this.exampleTable.readExamples((DataRowReader)new ListDataRowReader(this.vectors.iterator()));
        return this.exampleTable.createExampleSet(this.labelAtt, null, this.idAtt);
    }

    public void cleanUp() {
        this.exampleTable = null;
        this.exampleSetToExtend = null;
        this.vectors.clear();
        this.myOwnPrivateIdExampleMap.clear();
        this.wordAttributes = null;
        this.extractorAttributes.clear();
    }
}

