/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

public class Version {
    private final int major;
    private final int minor;
    private final int revision;

    public Version(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public String toString() {
        return Integer.toString(this.getMajor()) + "." + Integer.toString(this.getMinor()) + "." + Integer.toString(this.getRevision());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Version) {
            Version version = (Version)o;
            return this.getMajor() == version.getMajor() && this.getMinor() == version.getMinor() && this.getRevision() == version.getRevision();
        }
        return false;
    }

    public static Version parse(String version) {
        int indexFirstDot = version.indexOf(46);
        int indexSecondDot = version.indexOf(46, indexFirstDot + 1);
        if (indexFirstDot == -1 || indexSecondDot == -1) {
            throw new NumberFormatException("Invalid version!");
        }
        return new Version(Integer.parseInt(version.substring(0, indexFirstDot)), Integer.parseInt(version.substring(indexFirstDot + 1, indexSecondDot)), Integer.parseInt(version.substring(indexSecondDot + 1)));
    }

    public static Version currentVersion() {
        return new Version(1, 5, 1);
    }
}

