/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.IOException;
import java.util.HashMap;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.model.AbstractModel;
import opennlp.model.MaxentModel;
import opennlp.model.TwoPassDataIndexer;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizer;
import opennlp.tools.doccat.DocumentCategorizerContextGenerator;
import opennlp.tools.doccat.DocumentCategorizerEventStream;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.tokenize.SimpleTokenizer;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentCategorizerME
implements DocumentCategorizer {
    private static FeatureGenerator defaultFeatureGenerator = new BagOfWordsFeatureGenerator();
    private MaxentModel model;
    private DocumentCategorizerContextGenerator mContextGenerator;

    public DocumentCategorizerME(DoccatModel model, FeatureGenerator ... featureGenerators) {
        this.model = model.getChunkerModel();
        this.mContextGenerator = new DocumentCategorizerContextGenerator(featureGenerators);
    }

    public DocumentCategorizerME(DoccatModel model) {
        this(model, defaultFeatureGenerator);
    }

    @Deprecated
    public DocumentCategorizerME(MaxentModel model) {
        this(model, new BagOfWordsFeatureGenerator());
    }

    @Deprecated
    public DocumentCategorizerME(MaxentModel model, FeatureGenerator ... featureGenerators) {
        this.model = model;
        this.mContextGenerator = new DocumentCategorizerContextGenerator(featureGenerators);
    }

    @Override
    public double[] categorize(String[] text) {
        return this.model.eval(this.mContextGenerator.getContext(text));
    }

    @Override
    public double[] categorize(String documentText) {
        SimpleTokenizer tokenizer = SimpleTokenizer.INSTANCE;
        return this.categorize(tokenizer.tokenize(documentText));
    }

    @Override
    public String getBestCategory(double[] outcome) {
        return this.model.getBestOutcome(outcome);
    }

    @Override
    public int getIndex(String category) {
        return this.model.getIndex(category);
    }

    @Override
    public String getCategory(int index) {
        return this.model.getOutcome(index);
    }

    @Override
    public int getNumberOfCategories() {
        return this.model.getNumOutcomes();
    }

    @Override
    public String getAllResults(double[] results) {
        return this.model.getAllOutcomes(results);
    }

    @Deprecated
    public static AbstractModel train(DocumentCategorizerEventStream eventStream) throws IOException {
        return GIS.trainModel(100, new TwoPassDataIndexer(eventStream, 5));
    }

    public static DoccatModel train(String languageCode, ObjectStream<DocumentSample> samples, int cutoff, int iterations, FeatureGenerator ... featureGenerators) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        ModelUtil.addCutoffAndIterations(manifestInfoEntries, cutoff, iterations);
        GISModel model = GIS.trainModel(iterations, new TwoPassDataIndexer(new DocumentCategorizerEventStream(samples, featureGenerators), cutoff));
        return new DoccatModel(languageCode, model, manifestInfoEntries);
    }

    public static DoccatModel train(String languageCode, ObjectStream<DocumentSample> samples, int cutoff, int iterations) throws IOException {
        return DocumentCategorizerME.train(languageCode, samples, cutoff, iterations, defaultFeatureGenerator);
    }

    public static DoccatModel train(String languageCode, ObjectStream<DocumentSample> samples) throws IOException {
        return DocumentCategorizerME.train(languageCode, samples, 5, 100, defaultFeatureGenerator);
    }
}

