/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionarySerializer;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.dictionary.serializer.EntryInserter;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary
implements Iterable<StringList> {
    private Set<StringListWrapper> entrySet = new HashSet<StringListWrapper>();
    private boolean caseSensitive;

    public Dictionary() {
        this(false);
    }

    public Dictionary(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Dictionary(InputStream in) throws IOException, InvalidFormatException {
        this(in, false);
    }

    public Dictionary(InputStream in, boolean caseSensitive) throws IOException, InvalidFormatException {
        this.caseSensitive = caseSensitive;
        DictionarySerializer.create(in, new EntryInserter(){

            public void insert(Entry entry) {
                Dictionary.this.put(entry.getTokens());
            }
        });
    }

    public void put(StringList tokens) {
        this.entrySet.add(new StringListWrapper(tokens, this.caseSensitive));
    }

    public boolean contains(StringList tokens) {
        return this.entrySet.contains(new StringListWrapper(tokens, this.caseSensitive));
    }

    public void remove(StringList tokens) {
        this.entrySet.remove(new StringListWrapper(tokens, this.caseSensitive));
    }

    @Override
    public Iterator<StringList> iterator() {
        final Iterator<StringListWrapper> entries = this.entrySet.iterator();
        return new Iterator<StringList>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public StringList next() {
                return ((StringListWrapper)entries.next()).getStringList();
            }

            @Override
            public void remove() {
                entries.remove();
            }
        };
    }

    public int size() {
        return this.entrySet.size();
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entryIterator = new Iterator<Entry>(){
            private Iterator<StringList> dictionaryIterator;
            {
                this.dictionaryIterator = Dictionary.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.dictionaryIterator.hasNext();
            }

            @Override
            public Entry next() {
                StringList tokens = this.dictionaryIterator.next();
                return new Entry(tokens, new Attributes());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(out, entryIterator);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == this) {
            result = true;
        } else if (obj != null && obj instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)obj;
            result = ((Object)this.entrySet).equals(dictionary.entrySet);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return ((Object)this.entrySet).hashCode();
    }

    public String toString() {
        return this.entrySet.toString();
    }

    public static Dictionary parseOneEntryPerLine(Reader in) throws IOException {
        String line;
        BufferedReader lineReader = new BufferedReader(in);
        Dictionary dictionary = new Dictionary();
        while ((line = lineReader.readLine()) != null) {
            StringTokenizer whiteSpaceTokenizer = new StringTokenizer(line, " ");
            String[] tokens = new String[whiteSpaceTokenizer.countTokens()];
            if (tokens.length <= 0) continue;
            int tokenIndex = 0;
            while (whiteSpaceTokenizer.hasMoreTokens()) {
                tokens[tokenIndex++] = whiteSpaceTokenizer.nextToken();
            }
            dictionary.put(new StringList(tokens));
        }
        return dictionary;
    }

    private static class StringListWrapper {
        private final StringList stringList;
        private final boolean isCaseSensitive;

        private StringListWrapper(StringList stringList, boolean isCaseSensitive) {
            this.stringList = stringList;
            this.isCaseSensitive = isCaseSensitive;
        }

        private StringList getStringList() {
            return this.stringList;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof StringListWrapper) {
                StringListWrapper other = (StringListWrapper)obj;
                result = this.isCaseSensitive ? this.stringList.equals(other.getStringList()) : this.stringList.compareToIgnoreCase(other.getStringList());
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return this.stringList.toString().toLowerCase().hashCode();
        }

        public String toString() {
            return this.stringList.toString();
        }
    }
}

