/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.interpolation;

import java.util.Locale;
import javax.sound.sampled.AudioFormat;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.unitselection.interpolation.InterpolatingSynthesizer;

public class InterpolatingVoice
extends Voice {
    protected Voice firstVoice = null;

    public static boolean isInterpolatingVoiceName(String name) {
        if (name == null) {
            return false;
        }
        String[] parts = name.split("\\s+");
        if (parts.length != 4) {
            return false;
        }
        if (!parts[1].equals("with")) {
            return false;
        }
        if (!parts[2].endsWith("%")) {
            return false;
        }
        try {
            int percent = Integer.parseInt(parts[2].substring(0, parts[2].length() - 1));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (Voice.getVoice(parts[0]) == null) {
            return false;
        }
        return Voice.getVoice(parts[3]) != null;
    }

    public InterpolatingVoice(InterpolatingSynthesizer is, String name) throws MaryConfigurationException {
        super(name, null, null, is, null);
        if (InterpolatingVoice.isInterpolatingVoiceName(name)) {
            String[] parts = name.split("\\s+");
            this.firstVoice = Voice.getVoice(parts[0]);
        }
    }

    @Override
    public AllophoneSet getAllophoneSet() {
        if (this.firstVoice == null) {
            return null;
        }
        return this.firstVoice.getAllophoneSet();
    }

    @Override
    public Allophone getAllophone(String phoneSymbol) {
        if (this.firstVoice == null) {
            return null;
        }
        return this.firstVoice.getAllophone(phoneSymbol);
    }

    @Override
    public Locale getLocale() {
        if (this.firstVoice == null) {
            return null;
        }
        return this.firstVoice.getLocale();
    }

    @Override
    public AudioFormat dbAudioFormat() {
        if (this.firstVoice == null) {
            return null;
        }
        return this.firstVoice.dbAudioFormat();
    }

    @Override
    public Voice.Gender gender() {
        if (this.firstVoice == null) {
            return null;
        }
        return this.firstVoice.gender();
    }
}

