/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.window;

import marytts.signalproc.window.Window;

public class FlattopWindow
extends Window {
    public FlattopWindow(int length) {
        super(length);
    }

    public FlattopWindow(int length, double prescalingFactor) {
        super(length, prescalingFactor);
    }

    @Override
    protected void initialise() {
        boolean prescale = this.prescalingFactor != 1.0;
        for (int i = 0; i < this.window.length; ++i) {
            this.window[i] = 1.0 - 1.93 * Math.cos(Math.PI * 2 * (double)i / (double)(this.window.length - 1)) + 1.29 * Math.cos(Math.PI * 4 * (double)i / (double)(this.window.length - 1)) - 0.388 * Math.cos(Math.PI * 6 * (double)i / (double)(this.window.length - 1)) + 0.032 * Math.cos(Math.PI * 8 * (double)i / (double)(this.window.length - 1));
            if (!prescale) continue;
            int n = i;
            this.window[n] = this.window[n] * this.prescalingFactor;
        }
    }

    public String toString() {
        return "Bartlett window";
    }
}

