/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.BaseAudioEffect;
import marytts.signalproc.process.Robotiser;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.MathUtils;

public class RobotiserEffect
extends BaseAudioEffect {
    float amount;
    public static float DEFAULT_AMOUNT = 100.0f;
    public static float MAX_AMOUNT = 100.0f;
    public static float MIN_AMOUNT = 0.0f;

    public RobotiserEffect() {
        this(16000);
    }

    public RobotiserEffect(int samplingRate) {
        super(samplingRate);
        this.setExampleParameters("amount=100.0,");
        this.strHelpText = this.getHelpText();
    }

    @Override
    public void parseParameters(String param) {
        super.parseParameters(param);
        this.amount = this.expectFloatParameter("amount");
        if (this.amount == NULL_FLOAT_PARAM) {
            this.amount = DEFAULT_AMOUNT;
        }
        this.amount = MathUtils.CheckLimits(this.amount, MIN_AMOUNT, MAX_AMOUNT);
    }

    @Override
    public DoubleDataSource process(DoubleDataSource input) {
        Robotiser robotiser = new Robotiser(input, this.fs, this.amount / 100.0f);
        return new BufferedDoubleDataSource(robotiser);
    }

    @Override
    public String getHelpText() {
        String strHelp = "Robotiser Effect:" + strLineBreak + "Creates a robotic voice by setting all phases to zero." + strLineBreak + "Parameter:" + strLineBreak + "   <amount>" + "   Definition : The amount of robotic voice at the output" + strLineBreak + "   Range      : [" + String.valueOf(MIN_AMOUNT) + "," + String.valueOf(MAX_AMOUNT) + "]" + strLineBreak + "Example:" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "Robot";
    }
}

