/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.analysis.ShortTermCepstrumAnalyser;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.window.Window;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.MathUtils;
import marytts.util.string.PrintfFormat;

public class Cepstrogram
extends FunctionGraph {
    public static final int DEFAULT_WINDOW = 1;
    public static final int DEFAULT_FFTSIZE = 1024;
    public static final int DEFAULT_WINDOWSHIFT = 32;
    protected double dynamicRange;
    protected static final double QUEF_MAX = 0.016;
    protected double[] signal;
    protected int samplingRate;
    protected Window window;
    protected int windowShift;
    protected int fftSize;
    protected List<double[]> cepstra;
    protected double cepstra_max = 0.0;
    protected double cepstra_min = 0.0;
    protected double deltaQ = 0.0;
    protected int cepstra_indexmax = 0;

    public Cepstrogram(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public Cepstrogram(AudioInputStream ais, int width, int height) {
        this(ais, Window.get(1, 257), 32, 1024, width, height);
    }

    public Cepstrogram(AudioInputStream ais, Window window, int windowShift, int fftSize) {
        this(ais, window, windowShift, fftSize, 640, 480);
    }

    public Cepstrogram(AudioInputStream ais, Window window, int windowShift, int fftSize, int width, int height) {
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        if (!MathUtils.isPowerOfTwo(fftSize)) {
            throw new IllegalArgumentException("fftSize must be a power of two");
        }
        AudioDoubleDataSource signalSource = new AudioDoubleDataSource(ais);
        this.initialise(signalSource.getAllData(), signalSource.getSamplingRate(), window, windowShift, fftSize, width, height);
    }

    public Cepstrogram(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public Cepstrogram(double[] signal, int samplingRate, int width, int height) {
        this(signal, samplingRate, Window.get(1, 257), 32, 1024, width, height);
    }

    public Cepstrogram(double[] signal, int samplingRate, Window window, int windowShift, int fftSize, int width, int height) {
        this.initialise(signal, samplingRate, window, windowShift, fftSize, width, height);
    }

    protected void initialise(double[] aSignal, int aSamplingRate, Window aWindow, int aWindowShift, int aFftSize, int width, int height) {
        this.signal = aSignal;
        this.samplingRate = aSamplingRate;
        this.window = aWindow;
        this.windowShift = aWindowShift;
        this.fftSize = aFftSize;
        super.initialise(width, height, 0.0, (double)aWindowShift / (double)aSamplingRate, new double[10]);
        this.update();
    }

    protected void update() {
        ShortTermCepstrumAnalyser cepstrumAnalyser = new ShortTermCepstrumAnalyser((DoubleDataSource)new BufferedDoubleDataSource(this.signal), this.fftSize, 8192, this.window, this.windowShift, this.samplingRate);
        this.cepstra = new ArrayList<double[]>();
        this.deltaQ = cepstrumAnalyser.getQuefrencyResolution();
        long startTime = System.currentTimeMillis();
        this.cepstra_max = Double.NaN;
        this.cepstra_min = Double.NaN;
        FrameBasedAnalyser.FrameAnalysisResult<T>[] results = cepstrumAnalyser.analyseAllFrames();
        for (int i = 0; i < results.length; ++i) {
            double[] cepstrum = (double[])results[i].get();
            this.cepstra.add(cepstrum);
            for (int j = 0; j < cepstrum.length; ++j) {
                if (Double.isNaN(this.cepstra_min) || cepstrum[j] < this.cepstra_min) {
                    this.cepstra_min = cepstrum[j];
                }
                if (!Double.isNaN(this.cepstra_max) && !(cepstrum[j] > this.cepstra_max)) continue;
                this.cepstra_max = cepstrum[j];
            }
        }
        this.dynamicRange = this.cepstra_max - 0.0;
        long endTime = System.currentTimeMillis();
        System.err.println("Computed " + this.cepstra.size() + " cepstra in " + (endTime - startTime) + " ms.");
        this.cepstra_indexmax = (int)(0.016 / this.deltaQ);
        if (this.cepstra_indexmax > cepstrumAnalyser.getInverseFFTWindowLength() / 2) {
            this.cepstra_indexmax = cepstrumAnalyser.getInverseFFTWindowLength() / 2;
        }
        super.updateData(0.0, (double)this.windowShift / (double)this.samplingRate, new double[this.cepstra.size()]);
        this.ymax = 0.0;
        this.ymin = (double)(-this.cepstra_indexmax) * this.deltaQ;
        this.repaint();
    }

    @Override
    protected void drawData(Graphics2D g, int image_fromX, int image_toX, int image_refX, int image_refY, int startY, int image_height, double[] data, Color currentGraphColor, int currentGraphStyle, int currentDotStyle) {
        int index_fromX = this.imageX2indexX(image_fromX);
        int index_toX = this.imageX2indexX(image_toX);
        for (int i = index_fromX; i < index_toX; ++i) {
            int spectrumWidth = this.indexX2imageX(1);
            if (spectrumWidth == 0) {
                spectrumWidth = 1;
            }
            this.drawCepstrum(g, this.cepstra.get(i), image_refX + this.indexX2imageX(i), spectrumWidth, image_refY, image_height);
        }
    }

    protected void drawCepstrum(Graphics2D g, double[] cepstrum, int image_X, int image_width, int image_refY, int image_height) {
        int rect_height;
        double yScaleFactor = (double)image_height / (double)this.cepstra_indexmax;
        if (image_width < 2) {
            image_width = 2;
        }
        if ((rect_height = (int)Math.ceil(yScaleFactor)) < 2) {
            rect_height = 2;
        }
        for (int i = 0; i < this.cepstra_indexmax; ++i) {
            int color = Double.isNaN(cepstrum[i]) || cepstrum[i] < this.cepstra_max - this.dynamicRange ? 255 : (int)(255.0 * (this.cepstra_max - cepstrum[i]) / this.dynamicRange);
            g.setColor(new Color(color, color, color));
            g.fillRect(image_X, image_refY + (int)((double)i * yScaleFactor), image_width, rect_height);
        }
    }

    @Override
    protected String getLabel(double x, double y) {
        int precisionX = -((int)(Math.log(this.getXRange()) / Math.log(10.0))) + 2;
        if (precisionX < 0) {
            precisionX = 0;
        }
        int indexX = this.X2indexX(x);
        double[] spectrum = this.cepstra.get(indexX);
        int precisionY = -((int)(Math.log(this.getYRange()) / Math.log(10.0))) + 2;
        if (precisionY < 0) {
            precisionY = 0;
        }
        double E = spectrum[this.Y2indexY(y)];
        int precisionE = 1;
        return "E(" + new PrintfFormat("%." + precisionX + "f").sprintf(x) + "," + new PrintfFormat("%." + precisionY + "f").sprintf(y) + ")=" + new PrintfFormat("%." + precisionE + "f").sprintf(E);
    }

    protected int imageY2indexY(int imageY) {
        double y = this.imageY2Y(imageY);
        return this.Y2indexY(y);
    }

    protected int Y2indexY(double y) {
        assert (this.ymin == 0.0);
        return (int)((double)this.cepstra_indexmax * y / this.ymax);
    }

    @Override
    protected JPanel getControls() {
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        JLabel fftLabel = new JLabel("FFT size:");
        fftLabel.setAlignmentX(0.5f);
        controls.add(fftLabel);
        int min = 5;
        int max = 13;
        int deflt = (int)(Math.log(this.fftSize) / Math.log(2.0));
        JSlider fftSizeSlider = new JSlider(1, min, max, deflt);
        fftSizeSlider.setAlignmentX(0.5f);
        fftSizeSlider.setMajorTickSpacing(1);
        fftSizeSlider.setPaintTicks(true);
        fftSizeSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = min; i <= max; ++i) {
            int twoPowI = 1 << i;
            labelTable.put(new Integer(i), new JLabel(String.valueOf(twoPowI)));
        }
        fftSizeSlider.setLabelTable(labelTable);
        fftSizeSlider.setPaintLabels(true);
        fftSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int logfftSize;
                int newFftSize;
                JSlider source = (JSlider)ce.getSource();
                if (!source.getValueIsAdjusting() && (newFftSize = 1 << (logfftSize = source.getValue())) != Cepstrogram.this.fftSize) {
                    Cepstrogram.this.fftSize = newFftSize;
                    Cepstrogram.this.window = Window.get(Cepstrogram.this.window.type(), newFftSize / 4 + 1);
                    Cepstrogram.this.update();
                }
            }
        });
        controls.add(fftSizeSlider);
        JLabel windowTypeLabel = new JLabel("Window type:");
        windowTypeLabel.setAlignmentX(0.5f);
        controls.add(windowTypeLabel);
        int[] windowTypes = Window.getAvailableTypes();
        Window[] windows = new Window[windowTypes.length];
        int selected = 0;
        for (int i = 0; i < windowTypes.length; ++i) {
            windows[i] = Window.get(windowTypes[i], 1);
            if (windowTypes[i] != this.window.type()) continue;
            selected = i;
        }
        JComboBox<Window> windowList = new JComboBox<Window>(windows);
        windowList.setAlignmentX(0.5f);
        windowList.setSelectedIndex(selected);
        windowList.setMaximumSize(windowList.getPreferredSize());
        windowList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int newWindowType = ((Window)cb.getSelectedItem()).type();
                if (newWindowType != Cepstrogram.this.window.type()) {
                    Cepstrogram.this.window = Window.get(newWindowType, Cepstrogram.this.window.getLength());
                    Cepstrogram.this.update();
                }
            }
        });
        controls.add(windowList);
        return controls;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            Cepstrogram signalSpectrum = new Cepstrogram(ais);
            signalSpectrum.showInJFrame(args[i], true, true);
        }
    }
}

