/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.phonemiser;

import java.util.LinkedList;
import java.util.ListIterator;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;

public class Syllabifier {
    protected AllophoneSet allophoneSet;

    public Syllabifier(AllophoneSet allophoneSet) {
        this.allophoneSet = allophoneSet;
    }

    public String syllabify(String phoneString) {
        LinkedList<String> phoneList = this.splitIntoAllophones(phoneString);
        this.syllabify(phoneList);
        StringBuilder sb = new StringBuilder();
        for (String p : phoneList) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(p);
        }
        return sb.toString();
    }

    public void syllabify(LinkedList<String> phoneList) {
        Allophone ph;
        String s;
        boolean previousIsVowel;
        if (phoneList == null) {
            return;
        }
        ListIterator<String> it = phoneList.listIterator(0);
        if (!it.hasNext()) {
            return;
        }
        Allophone previous = this.getAllophone(it.next());
        boolean bl = previousIsVowel = previous != null && previous.sonority() >= 4;
        while (it.hasNext()) {
            boolean nextIsVowel;
            Allophone next = this.getAllophone(it.next());
            boolean bl2 = nextIsVowel = next != null && next.sonority() >= 4;
            if (previousIsVowel && nextIsVowel && !next.name().equals("6")) {
                it.previous();
                it.add("-");
                it.next();
            }
            previousIsVowel = nextIsVowel;
        }
        it = phoneList.listIterator(0);
        int minSonority = 7;
        int minIndex = -1;
        int syllableStart = -1;
        while (it.hasNext()) {
            s = it.next();
            if (s.equals("-")) {
                minSonority = 7;
                minIndex = -1;
                syllableStart = it.previousIndex();
                continue;
            }
            ph = this.getAllophone(s);
            if (ph != null && ph.sonority() < minSonority) {
                minSonority = ph.sonority();
                minIndex = it.previousIndex();
                continue;
            }
            if (ph == null || ph.sonority() < 4) continue;
            if (minIndex > syllableStart + 1) {
                int steps = 0;
                while (it.nextIndex() > minIndex) {
                    ++steps;
                    it.previous();
                }
                it.add(".");
                while (steps > 0) {
                    it.next();
                    --steps;
                }
            }
            minSonority = 7;
            minIndex = -1;
        }
        it = phoneList.listIterator(0);
        while (it.hasNext()) {
            s = it.next();
            if (!s.equals(".")) continue;
            it.previous();
            ph = this.getAllophone(it.previous());
            it.next();
            it.next();
            if (ph != null && ph.sonority() == 5) {
                ph = this.getAllophone(it.next());
                if (ph != null && ph.sonority() <= 3) {
                    ph = this.getAllophone(it.next());
                    if (ph != null && ph.sonority() <= 3) {
                        it.previous();
                        it.previous();
                        it.previous();
                        it.remove();
                        it.next();
                        it.add("-");
                        continue;
                    }
                    it.previous();
                    it.previous();
                    it.previous();
                    it.set("-");
                    continue;
                }
                it.previous();
                it.previous();
                it.set("-");
                continue;
            }
            it.set("-");
        }
        it = phoneList.listIterator(0);
        while (it.hasNext()) {
            s = it.next();
            if (!s.equals("-") || (ph = this.getAllophone(it.next())) == null || !ph.name().equals("N") || (ph = this.getAllophone(it.next())) == null || ph.sonority() < 5) continue;
            it.previous();
            it.previous();
            it.previous();
            it.remove();
            it.next();
            it.add("-");
        }
        this.correctStressSymbol(phoneList);
    }

    protected void correctStressSymbol(LinkedList<String> phoneList) {
        String s;
        boolean stressFound = false;
        ListIterator<String> it = phoneList.listIterator(0);
        while (it.hasNext()) {
            s = it.next();
            if (!s.endsWith("1")) continue;
            it.set(s.substring(0, s.length() - 1));
            if (stressFound) continue;
            int steps = 0;
            while (it.hasPrevious()) {
                ++steps;
                String t = it.previous();
                if (!t.equals("-") && !t.equals("_")) continue;
                it.next();
                --steps;
                break;
            }
            it.add("'");
            while (steps > 0) {
                it.next();
                --steps;
            }
            stressFound = true;
        }
        if (!stressFound) {
            it = phoneList.listIterator(0);
            while (it.hasNext()) {
                s = it.next();
                Allophone ph = this.allophoneSet.getAllophone(s);
                if (ph == null || ph.sonority() < 5) continue;
                int steps = 0;
                while (it.hasPrevious()) {
                    ++steps;
                    String t = it.previous();
                    if (!t.equals("-") && !t.equals("_")) continue;
                    it.next();
                    --steps;
                    break;
                }
                it.add("'");
                while (steps > 0) {
                    it.next();
                    --steps;
                }
                break block3;
            }
        }
    }

    protected LinkedList<String> splitIntoAllophones(String phoneString) {
        LinkedList<String> phoneList = new LinkedList<String>();
        for (int i = 0; i < phoneString.length(); ++i) {
            String name = null;
            for (int j = 3; j >= 1; --j) {
                String candidate;
                if (i + j > phoneString.length() || this.getAllophone(candidate = phoneString.substring(i, i + j)) == null) continue;
                name = candidate;
                i += j - 1;
                break;
            }
            if (name == null) continue;
            phoneList.add(name);
        }
        return phoneList;
    }

    protected Allophone getAllophone(String phone) {
        if (phone.endsWith("1")) {
            return this.allophoneSet.getAllophone(phone.substring(0, phone.length() - 1));
        }
        return this.allophoneSet.getAllophone(phone);
    }
}

