/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import java.util.List;
import marytts.datatypes.MaryDataType;
import marytts.modules.XML2UttBase;
import marytts.modules.synthesis.FreeTTSVoices;
import marytts.modules.synthesis.Voice;
import org.w3c.dom.Element;

public class XML2UttAcoustParams
extends XML2UttBase {
    public XML2UttAcoustParams() {
        super("XML2Utt AcoustParams", MaryDataType.ACOUSTPARAMS, MaryDataType.FREETTS_ACOUSTPARAMS, null);
    }

    @Override
    public void powerOnSelfTest() throws Error {
    }

    public Utterance convert(List<Element> tokensAndBoundaries, Voice maryVoice) {
        com.sun.speech.freetts.Voice freettsVoice = FreeTTSVoices.getFreeTTSVoice(maryVoice);
        if (freettsVoice == null) {
            throw new NullPointerException("No FreeTTS voice for mary voice " + maryVoice.getName());
        }
        Utterance utterance = new Utterance(freettsVoice);
        utterance.createRelation("Token");
        utterance.createRelation("Word");
        utterance.createRelation("SylStructure");
        utterance.createRelation("Syllable");
        utterance.createRelation("Segment");
        utterance.createRelation("Target");
        utterance.createRelation("Phrase");
        for (Element el : tokensAndBoundaries) {
            this.addOneElement(utterance, el, true, true, true);
        }
        Item phraseItem = utterance.getRelation("Phrase").getTail();
        if (phraseItem != null && !phraseItem.getFeatures().isPresent("name")) {
            phraseItem.getFeatures().setString("name", "BB");
        }
        Relation segmentRelation = utterance.getRelation("Segment");
        Relation targetRelation = utterance.getRelation("Target");
        assert (segmentRelation != null);
        assert (targetRelation != null);
        Item lastSegment = segmentRelation.getTail();
        if (lastSegment != null && lastSegment.getFeatures().isPresent("end")) {
            float pos = lastSegment.getFeatures().getFloat("end");
            Item lastTarget = targetRelation.getTail();
            float f0 = lastTarget != null ? lastTarget.getFeatures().getFloat("f0") : 100.0f;
            Item finalTarget = targetRelation.appendItem();
            finalTarget.getFeatures().setFloat("pos", pos);
            finalTarget.getFeatures().setFloat("f0", f0);
        }
        return utterance;
    }

    @Override
    protected void fillUtterance(Utterance utterance, Element sentence) {
        this.fillUtterance(utterance, sentence, true, true, true);
    }
}

