/*
 * Decompiled with CFR 0.152.
 */
package emotionml;

import emotionml.EmotionML;
import emotionml.EmotionVocabulary;
import emotionml.exceptions.ConfigurationException;
import emotionml.exceptions.NoSuchVocabularyException;
import emotionml.exceptions.NotValidEmotionmlException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Checker {
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private Schema emotionmlSchema;
    private DocumentBuilder builder;

    public Checker() throws ConfigurationException {
        this.factory.setNamespaceAware(true);
        try {
            this.emotionmlSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(Checker.class.getResource("emotionml.xsd"));
        }
        catch (SAXException e) {
            throw new ConfigurationException("Could not instantiate schema", e);
        }
        this.factory.setSchema(this.emotionmlSchema);
        try {
            this.builder = this.factory.newDocumentBuilder();
            this.builder.setErrorHandler(new ErrorHandler());
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Cannot instantiate parser", e);
        }
    }

    public Document parse(InputStream emotionmlStream) throws NotValidEmotionmlException {
        Document doc = null;
        try {
            doc = this.builder.parse(emotionmlStream);
        }
        catch (Exception e) {
            throw new NotValidEmotionmlException("Cannot parse EmotionML", e);
        }
        this.validateStandaloneManually(doc);
        return doc;
    }

    public void validate(Document emotionml) throws NotValidEmotionmlException {
        try {
            this.emotionmlSchema.newValidator().validate(new DOMSource(emotionml));
        }
        catch (Exception e) {
            throw new NotValidEmotionmlException("Could not schema-validate source", e);
        }
        this.validateStandaloneManually(emotionml);
    }

    public void validateFragment(DocumentFragment emotionmlFragment) throws NotValidEmotionmlException {
        try {
            this.emotionmlSchema.newValidator().validate(new DOMSource(emotionmlFragment));
        }
        catch (Exception e) {
            throw new NotValidEmotionmlException("Could not schema-validate source", e);
        }
        this.validateFragmentManually(emotionmlFragment);
    }

    private void validateStandaloneManually(Document emotionmlDocument) throws NotValidEmotionmlException {
        this.validateRootElement(emotionmlDocument);
        Element emotionmlElement = emotionmlDocument.getDocumentElement();
        this.validateVocabularySets(emotionmlElement);
        this.validateManually(emotionmlElement);
    }

    private void validateFragmentManually(DocumentFragment emotionmlFragment) throws NotValidEmotionmlException {
        this.validateManually(emotionmlFragment);
    }

    private void validateManually(Node emotionmlFragment) throws NotValidEmotionmlException {
        NodeList kids = emotionmlFragment.getChildNodes();
        int i = 0;
        int len = kids.getLength();
        while (i < len) {
            Element e;
            Node n = kids.item(i);
            if (n.getNodeType() == 1 && "emotion".equals((e = (Element)n).getTagName()) && "http://www.w3.org/2009/10/emotionml".equals(e.getNamespaceURI())) {
                this.validateVocabularySets(e);
                this.validateVersion(e);
                this.validateDescriptors(e);
            }
            ++i;
        }
    }

    private void validateDescriptors(Element emotion) throws NotValidEmotionmlException {
        assert (emotion.getLocalName().equals("emotion"));
        NodeList children = emotion.getChildNodes();
        int i = 0;
        int len = children.getLength();
        while (i < len) {
            Element c;
            String childLocalName;
            Node n = children.item(i);
            if (n.getNodeType() == 1 && EmotionML.descriptionTags.contains(childLocalName = (c = (Element)n).getLocalName())) {
                this.validateDescription(c);
            }
            ++i;
        }
    }

    private void validateDescription(Element desc) throws NotValidEmotionmlException {
        EmotionVocabulary declaredVocabulary;
        Element root;
        String descType = desc.getLocalName();
        assert (EmotionML.descriptionTags.contains(descType));
        String vocabularyAttribute = String.valueOf(descType) + "-set";
        Element emotion = (Element)desc.getParentNode();
        String declaredVocabularyUri = emotion.getAttribute(vocabularyAttribute);
        if ("".equals(declaredVocabularyUri) && "http://www.w3.org/2009/10/emotionml".equals((root = desc.getOwnerDocument().getDocumentElement()).getNamespaceURI()) && "emotionml".equals(root.getLocalName())) {
            declaredVocabularyUri = root.getAttribute(vocabularyAttribute);
        }
        if ("".equals(declaredVocabularyUri)) {
            throw new NotValidEmotionmlException("<" + descType + "> element used without declaring a " + descType + " vocabulary through the '" + vocabularyAttribute + "' attribute");
        }
        try {
            declaredVocabulary = this.isLocallyDefined(declaredVocabularyUri) ? EmotionVocabulary.get(desc.getOwnerDocument(), this.getIdFromLocalVocabularyUri(declaredVocabularyUri)) : EmotionVocabulary.get(declaredVocabularyUri);
        }
        catch (NoSuchVocabularyException e) {
            throw new NotValidEmotionmlException("Cannot get vocabulary for uri '" + declaredVocabularyUri + "'", e);
        }
        String name = desc.getAttribute("name");
        if (!declaredVocabulary.getItems().contains(name)) {
            throw new NotValidEmotionmlException("The name '" + name + "' of element <" + descType + "> is not contained in the declared vocabulary '" + declaredVocabularyUri + "'");
        }
        boolean hasTraceChild = desc.getElementsByTagNameNS("http://www.w3.org/2009/10/emotionml", "trace").getLength() > 0;
        boolean hasValueAttribute = desc.hasAttribute("value");
        if (hasTraceChild && hasValueAttribute) {
            throw new NotValidEmotionmlException("Either a 'value' attribute or a <trace> child may be used, but not both");
        }
        if ("dimension".equals(descType) && !hasTraceChild && !hasValueAttribute) {
            throw new NotValidEmotionmlException("<dimension> requires either a 'value' attribute or a <trace> child.");
        }
    }

    private void validateVersion(Element emotion) throws NotValidEmotionmlException {
        assert (emotion.getLocalName().equals("emotion"));
        if (!emotion.hasAttribute("version")) {
            return;
        }
        String version = emotion.getAttribute("version");
        if (!version.equals("1.0")) {
            throw new NotValidEmotionmlException("Version attribute of <emotion> should be '1.0' but is '" + version + "'");
        }
    }

    private void validateVocabularySets(Element element) throws NotValidEmotionmlException {
        assert (element != null);
        for (String attName : EmotionML.vocabularyAttributeTypes.keySet()) {
            EmotionVocabulary voc;
            EmotionVocabulary.Type expectedType = EmotionML.vocabularyAttributeTypes.get(attName);
            if (!element.hasAttribute(attName)) continue;
            String vocabularyUri = element.getAttribute(attName);
            try {
                voc = this.isLocallyDefined(vocabularyUri) ? EmotionVocabulary.get(element.getOwnerDocument(), this.getIdFromLocalVocabularyUri(vocabularyUri)) : EmotionVocabulary.get(vocabularyUri);
            }
            catch (NoSuchVocabularyException e) {
                throw new NotValidEmotionmlException("Cannot get vocabulary definition from " + vocabularyUri, e);
            }
            if (voc.getType() == expectedType) continue;
            throw new NotValidEmotionmlException("The vocabulary referred to in '" + attName + "' should be of type '" + (Object)((Object)expectedType) + "' but is of type '" + (Object)((Object)voc.getType()) + "'");
        }
    }

    private String getIdFromLocalVocabularyUri(String vocabularyUri) {
        assert (vocabularyUri.startsWith("#"));
        return vocabularyUri.substring(1);
    }

    private boolean isLocallyDefined(String vocabularyUri) {
        return vocabularyUri.startsWith("#");
    }

    private void validateRootElement(Document emotionmlDocument) throws NotValidEmotionmlException {
        if (emotionmlDocument == null || emotionmlDocument.getDocumentElement() == null || !"emotionml".equals(emotionmlDocument.getDocumentElement().getLocalName())) {
            throw new NotValidEmotionmlException("The root element of standalone EmotionML documents MUST be <emotionml>.");
        }
    }

    public Schema getEmotionmlSchema() {
        return this.emotionmlSchema;
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private ErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

