/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.Utterance;
import java.util.LinkedList;

public class OutputQueue {
    private LinkedList list = new LinkedList();
    private int size;
    private static final int DEFAULT_SIZE = 5;
    private volatile boolean closed = false;

    public OutputQueue(int size) {
        this.size = size;
    }

    public OutputQueue() {
        this(5);
    }

    public synchronized void post(Utterance utterance) {
        if (this.closed) {
            throw new IllegalStateException("output queue closed");
        }
        while (this.list.size() >= this.size) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.list.add(utterance);
        this.notify();
    }

    public synchronized void close() {
        this.closed = true;
        this.list.add(null);
        this.notify();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized Utterance pend() {
        Utterance utterance = null;
        while (this.list.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        utterance = (Utterance)this.list.removeFirst();
        this.notify();
        return utterance;
    }

    public synchronized void removeAll() {
        this.list.clear();
    }
}

