/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.toolbox;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KullbackLeiblerDistanceCalculator {
    private int sequencesLength = 1000;
    private int nbSequences = 10;

    public <O extends Observation> double distance(Hmm<O> hmm1, Hmm<? super O> hmm2) {
        double distance = 0.0;
        int i = 0;
        while (i < this.nbSequences) {
            List<O> oseq = new MarkovGenerator<O>(hmm1).observationSequence(this.sequencesLength);
            distance += (new ForwardBackwardScaledCalculator(oseq, hmm1).lnProbability() - new ForwardBackwardScaledCalculator(oseq, hmm2).lnProbability()) / (double)this.sequencesLength;
            ++i;
        }
        return distance / (double)this.nbSequences;
    }

    public int getNbSequences() {
        return this.nbSequences;
    }

    public void setNbSequences(int nb) {
        this.nbSequences = nb;
    }

    public int getSequencesLength() {
        return this.sequencesLength;
    }

    public void setSequencesLength(int length) {
        this.sequencesLength = length;
    }
}

