/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardBackwardCalculator {
    protected double[][] alpha = null;
    protected double[][] beta = null;
    protected double probability;

    protected ForwardBackwardCalculator() {
    }

    public <O extends Observation> ForwardBackwardCalculator(List<? extends O> oseq, Hmm<O> hmm, EnumSet<Computation> flags) {
        if (oseq.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty sequence");
        }
        if (flags.contains((Object)Computation.ALPHA)) {
            this.computeAlpha(hmm, oseq);
        }
        if (flags.contains((Object)Computation.BETA)) {
            this.computeBeta(hmm, oseq);
        }
        this.computeProbability(oseq, hmm, flags);
    }

    public <O extends Observation> ForwardBackwardCalculator(List<? extends O> oseq, Hmm<O> hmm) {
        this(oseq, hmm, EnumSet.of(Computation.ALPHA));
    }

    protected <O extends Observation> void computeAlpha(Hmm<? super O> hmm, List<O> oseq) {
        this.alpha = new double[oseq.size()][hmm.nbStates()];
        int i = 0;
        while (i < hmm.nbStates()) {
            this.computeAlphaInit(hmm, (Observation)oseq.get(0), i);
            ++i;
        }
        Iterator<O> seqIterator = oseq.iterator();
        if (seqIterator.hasNext()) {
            seqIterator.next();
        }
        int t = 1;
        while (t < oseq.size()) {
            Observation observation = (Observation)seqIterator.next();
            int i2 = 0;
            while (i2 < hmm.nbStates()) {
                this.computeAlphaStep(hmm, observation, t, i2);
                ++i2;
            }
            ++t;
        }
    }

    protected <O extends Observation> void computeAlphaInit(Hmm<? super O> hmm, O o, int i) {
        this.alpha[0][i] = hmm.getPi(i) * hmm.getOpdf(i).probability(o);
    }

    protected <O extends Observation> void computeAlphaStep(Hmm<? super O> hmm, O o, int t, int j) {
        double sum = 0.0;
        int i = 0;
        while (i < hmm.nbStates()) {
            sum += this.alpha[t - 1][i] * hmm.getAij(i, j);
            ++i;
        }
        this.alpha[t][j] = sum * hmm.getOpdf(j).probability(o);
    }

    protected <O extends Observation> void computeBeta(Hmm<? super O> hmm, List<O> oseq) {
        this.beta = new double[oseq.size()][hmm.nbStates()];
        int i = 0;
        while (i < hmm.nbStates()) {
            this.beta[oseq.size() - 1][i] = 1.0;
            ++i;
        }
        int t = oseq.size() - 2;
        while (t >= 0) {
            int i2 = 0;
            while (i2 < hmm.nbStates()) {
                this.computeBetaStep(hmm, (Observation)oseq.get(t + 1), t, i2);
                ++i2;
            }
            --t;
        }
    }

    protected <O extends Observation> void computeBetaStep(Hmm<? super O> hmm, O o, int t, int i) {
        double sum = 0.0;
        int j = 0;
        while (j < hmm.nbStates()) {
            sum += this.beta[t + 1][j] * hmm.getAij(i, j) * hmm.getOpdf(j).probability(o);
            ++j;
        }
        this.beta[t][i] = sum;
    }

    public double alphaElement(int t, int i) {
        if (this.alpha == null) {
            throw new UnsupportedOperationException("Alpha array has not been computed");
        }
        return this.alpha[t][i];
    }

    public double betaElement(int t, int i) {
        if (this.beta == null) {
            throw new UnsupportedOperationException("Beta array has not been computed");
        }
        return this.beta[t][i];
    }

    private <O extends Observation> void computeProbability(List<O> oseq, Hmm<? super O> hmm, EnumSet<Computation> flags) {
        this.probability = 0.0;
        if (flags.contains((Object)Computation.ALPHA)) {
            int i = 0;
            while (i < hmm.nbStates()) {
                this.probability += this.alpha[oseq.size() - 1][i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < hmm.nbStates()) {
                this.probability += hmm.getPi(i) * hmm.getOpdf(i).probability((Observation)oseq.get(0)) * this.beta[0][i];
                ++i;
            }
        }
    }

    public double probability() {
        return this.probability;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Computation {
        ALPHA,
        BETA;

    }
}

