/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class MaxFunction
extends AbstractAggregationFunction {
    private double maxValue;

    public MaxFunction() {
        this(true);
    }

    public MaxFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    public String getName() {
        return "maximum";
    }

    protected void reset() {
        this.foundMissing = false;
        this.maxValue = Double.NEGATIVE_INFINITY;
    }

    public void update(double value, double weight) {
        this.update(value);
    }

    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        if (value > this.maxValue) {
            this.maxValue = value;
        }
    }

    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        return this.maxValue;
    }

    public boolean supportsAttribute(Attribute attribute) {
        return attribute.isNumerical();
    }
}

