/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.att;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.att.AttributeDataSource;
import com.rapidminer.tools.att.AttributeDataSources;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeSet {
    private List<Attribute> regularAttributes = new ArrayList<Attribute>();
    private Map<String, Attribute> specialAttributes = new HashMap<String, Attribute>();
    private File defaultSource;

    public AttributeSet() {
    }

    public AttributeSet(int initialCapacity) {
        this.regularAttributes = new ArrayList<Attribute>(initialCapacity);
    }

    public AttributeSet(AttributeDataSources attributeDataSources) throws UserError {
        for (AttributeDataSource ads : attributeDataSources.getDataSources()) {
            if (ads.getType().equals("attribute")) {
                this.addAttribute(ads.getAttribute());
                continue;
            }
            Attribute attribute = this.specialAttributes.get(ads.getType());
            if (attribute != null) {
                throw new UserError(null, 402, "Special attribute name '" + ads.getType() + "' was used more than one time. Please make sure that the names of special attributes (e.g. 'label' or 'id') are unique.");
            }
            this.setSpecialAttribute(ads.getType(), ads.getAttribute());
        }
        this.defaultSource = attributeDataSources.getDefaultSource();
    }

    public AttributeSet(File attributeDescriptionFile, boolean sourceColRequired, LoggingHandler logging) throws XMLException, ParserConfigurationException, SAXException, IOException, UserError {
        this(AttributeDataSource.createAttributeDataSources(attributeDescriptionFile, sourceColRequired, logging));
    }

    public AttributeSet(List<Attribute> regularAttributes, Map<String, Attribute> specialAttributes) {
        this.regularAttributes = regularAttributes;
        this.specialAttributes = specialAttributes;
    }

    public File getDefaultSource() {
        return this.defaultSource;
    }

    public Attribute getAttribute(int index) {
        return this.regularAttributes.get(index);
    }

    public void addAttribute(Attribute attribute) {
        this.regularAttributes.add(attribute);
    }

    public Attribute getSpecialAttribute(String name) {
        return this.specialAttributes.get(name);
    }

    public void setSpecialAttribute(String name, Attribute attribute) {
        this.specialAttributes.put(name, attribute);
    }

    public Set<String> getSpecialNames() {
        return this.specialAttributes.keySet();
    }

    public List<Attribute> getRegularAttributes() {
        return this.regularAttributes;
    }

    public int getNumberOfRegularAttributes() {
        return this.regularAttributes.size();
    }

    public Map<String, Attribute> getSpecialAttributes() {
        return this.specialAttributes;
    }

    public List<Attribute> getAllAttributes() {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        attributes.addAll(this.regularAttributes);
        attributes.addAll(this.specialAttributes.values());
        return attributes;
    }
}

