/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.visualization.dependencies.TransitionGraph;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionGraphOperator
extends Operator {
    public static final String PARAMETER_SOURCE_ATTRIBUTE = "source_attribute";
    public static final String PARAMETER_TARGET_ATTRIBUTE = "target_attribute";
    public static final String PARAMETER_STRENGTH_ATTRIBUTE = "strength_attribute";
    public static final String PARAMETER_TYPE_ATTRIBUTE = "type_attribute";
    public static final String PARAMETER_NODE_DESCRIPTION = "node_description";

    public TransitionGraphOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        String sourceAttribute = this.getParameterAsString(PARAMETER_SOURCE_ATTRIBUTE);
        if (exampleSet.getAttributes().get(sourceAttribute) == null) {
            throw new UserError((Operator)this, 111, sourceAttribute);
        }
        String targetAttribute = this.getParameterAsString(PARAMETER_TARGET_ATTRIBUTE);
        if (exampleSet.getAttributes().get(targetAttribute) == null) {
            throw new UserError((Operator)this, 111, targetAttribute);
        }
        String strengthAttribute = null;
        if (this.isParameterSet(PARAMETER_STRENGTH_ATTRIBUTE)) {
            strengthAttribute = this.getParameterAsString(PARAMETER_STRENGTH_ATTRIBUTE);
        }
        if (strengthAttribute != null) {
            if (exampleSet.getAttributes().get(strengthAttribute) == null) {
                throw new UserError((Operator)this, 111, strengthAttribute);
            }
            if (!exampleSet.getAttributes().get(strengthAttribute).isNumerical()) {
                throw new UserError((Operator)this, 144, strengthAttribute, this.getName());
            }
        }
        String typeAttribute = null;
        if (this.isParameterSet(PARAMETER_TYPE_ATTRIBUTE)) {
            typeAttribute = this.getParameterAsString(PARAMETER_TYPE_ATTRIBUTE);
        }
        if (typeAttribute != null && exampleSet.getAttributes().get(typeAttribute) == null) {
            throw new UserError((Operator)this, 111, typeAttribute);
        }
        String nodeDescription = null;
        if (this.isParameterSet(PARAMETER_NODE_DESCRIPTION)) {
            nodeDescription = this.getParameterAsString(PARAMETER_NODE_DESCRIPTION);
        }
        TransitionGraph transitionGraph = new TransitionGraph(sourceAttribute, targetAttribute, strengthAttribute, typeAttribute, nodeDescription);
        return new IOObject[]{exampleSet, transitionGraph};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, TransitionGraph.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_SOURCE_ATTRIBUTE, "The name of the attribute defining the sources of the transitions.", false));
        types.add(new ParameterTypeString(PARAMETER_TARGET_ATTRIBUTE, "The name of the attribute defining the targets of the transitions.", false));
        types.add(new ParameterTypeString(PARAMETER_STRENGTH_ATTRIBUTE, "The name of the attribute defining the strength of the transitions.", true));
        types.add(new ParameterTypeString(PARAMETER_TYPE_ATTRIBUTE, "The name of the attribute defining the type of the transitions.", true));
        types.add(new ParameterTypeString(PARAMETER_NODE_DESCRIPTION, "The description of each node where columns from the example data can be used by the macro form %{COLUMN_NAME}."));
        return types;
    }
}

