/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.text;

import com.rapidminer.operator.ResultObjectAdapter;

public class TextObject
extends ResultObjectAdapter {
    private static final long serialVersionUID = 7719788736766297420L;
    public static final int NO_LABEL = 0;
    public static final int REGRESSION_LABEL = 1;
    public static final int CLASSIFICATION_LABEL = 2;
    private String text;
    private int labelType;
    private double regressionLabel;
    private String classificationLabel;

    public TextObject(String text) {
        this.text = text;
    }

    public TextObject(String text, double label) {
        this.text = text;
        this.labelType = 1;
        this.regressionLabel = label;
    }

    public TextObject(String text, String label) {
        this.text = text;
        this.labelType = 2;
        this.classificationLabel = label;
    }

    public String getText() {
        return this.text;
    }

    public boolean isLabeled() {
        return this.labelType != 0;
    }

    public int getLabelType() {
        return this.labelType;
    }

    public String getClassificationLabel() {
        return this.classificationLabel;
    }

    public double getRegressionLabel() {
        return this.regressionLabel;
    }

    public String getExtension() {
        return "txt";
    }

    public String getFileDescription() {
        return "Text";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.text);
        if (this.labelType != 0) {
            buffer.append("\n\nLabel:");
            if (this.labelType == 1) {
                buffer.append(this.regressionLabel);
            } else {
                buffer.append(this.classificationLabel);
            }
        }
        return buffer.toString();
    }
}

