/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSampling
extends AbstractSamplingOperator {
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    public static final String PARAMETER_USE_LOCAL_RANDOM_SEED = "use_local_random_seed";
    private double fraction = 0.1;

    public SimpleSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        this.fraction = this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO);
        LinkedList<DataRow> dataList = new LinkedList<DataRow>();
        Iterator reader = exampleSet.iterator();
        RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();
        if (this.getParameterAsBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED)) {
            random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        }
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            if (this.accept(example, random)) {
                dataList.add(example.getDataRow());
            }
            this.checkForStop();
        }
        List<Attribute> attributes = Arrays.asList(exampleSet.getExampleTable().getAttributes());
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes, new ListDataRowReader(dataList.iterator()));
        LinkedList<Attribute> regularAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            regularAttributes.add(attribute);
        }
        SimpleExampleSet result = new SimpleExampleSet((ExampleTable)exampleTable, regularAttributes);
        Iterator<AttributeRole> special = exampleSet.getAttributes().specialAttributes();
        while (special.hasNext()) {
            AttributeRole role = special.next();
            result.getAttributes().setSpecialAttribute(role.getAttribute(), role.getSpecialName());
        }
        return result;
    }

    protected boolean accept(Example example, RandomGenerator random) throws UndefinedParameterError {
        return random.nextDouble() < this.fraction;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of examples which should be sampled", 0.0, 1.0, 0.1);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED, "Indicates if a local random seed should be used to draw random numbers. Otherwise the global generator will be used.", false));
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_LOCAL_RANDOM_SEED, true, true));
        types.add(type);
        return types;
    }
}

