/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.outlier.AbstractOutlierDetection;
import com.rapidminer.operator.preprocessing.outlier.SearchObject;
import com.rapidminer.operator.preprocessing.outlier.SearchSpace;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBOutlierOperator
extends AbstractOutlierDetection {
    public static final String PARAMETER_DISTANCE = "distance";
    public static final String PARAMETER_PROPORTION = "proportion";
    public static final String PARAMETER_DISTANCE_FUNCTION = "distance_function";
    private static final String[] distanceFunctionList = new String[]{"euclidian distance", "squared distance", "cosine distance", "inverted cosine distance", "angle"};

    public DBOutlierOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        double d = this.getParameterAsDouble(PARAMETER_DISTANCE);
        double p = this.getParameterAsDouble(PARAMETER_PROPORTION);
        int kindOfDistance = this.getParameterAsInt(PARAMETER_DISTANCE_FUNCTION);
        Iterator reader = eSet.iterator();
        int searchSpaceDimension = eSet.getAttributes().size();
        SearchSpace sr = new SearchSpace(searchSpaceDimension);
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            SearchObject so = new SearchObject(searchSpaceDimension, "object" + counter);
            ++counter;
            int i = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                so.setVektor(i++, example.getValue(attribute));
            }
            sr.addObject(so);
        }
        this.log("Searching d=" + sr.getDimensions() + " dimensions with D=" + d + " distance and p=" + p + " .");
        sr.resetOutlierStatus();
        sr.allRadiusSearch(d, p, kindOfDistance);
        Attribute outlierAttribute = AttributeFactory.createAttribute("Outlier", 6);
        outlierAttribute.getMapping().mapString("false");
        outlierAttribute.getMapping().mapString("true");
        eSet.getExampleTable().addAttribute(outlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        counter = 0;
        for (Example example : eSet) {
            if (sr.getSearchObjectOutlierStatus(counter)) {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("true"));
            } else {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("false"));
            }
            ++counter;
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_DISTANCE, "The distance for objects.", 0.0, Double.POSITIVE_INFINITY));
        types.add(new ParameterTypeDouble(PARAMETER_PROPORTION, "The proportion of objects related to D.", 0.0, 1.0));
        types.add(new ParameterTypeCategory(PARAMETER_DISTANCE_FUNCTION, "Indicates which distance function will be used for calculating the distance between two objects", distanceFunctionList, 0));
        return types;
    }
}

