/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeMerge
extends AbstractDataProcessing {
    public static final String PARAMETER_FIRST_ATTRIBUTE = "first_attribute";
    public static final String PARAMETER_SECOND_ATTRIBUTE = "second_attribute";
    public static final String PARAMETER_SEPARATOR = "separator";
    public static final String PARAMETER_TRIM_VALUES = "trim_values";

    public AttributeMerge(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String firstAttributeName = this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE);
        String secondAttributeName = this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE);
        String separatorString = this.getParameterAsString(PARAMETER_SEPARATOR);
        boolean trimValues = this.getParameterAsBoolean(PARAMETER_TRIM_VALUES);
        Attribute firstAttribute = exampleSet.getAttributes().get(firstAttributeName);
        if (firstAttribute == null) {
            throw new UserError((Operator)this, 111, firstAttributeName);
        }
        Attribute secondAttribute = exampleSet.getAttributes().get(secondAttributeName);
        if (secondAttribute == null) {
            throw new UserError((Operator)this, 111, secondAttributeName);
        }
        Attribute mergedAttribute = AttributeFactory.createAttribute(String.valueOf(firstAttribute.getName()) + separatorString + secondAttribute.getName(), 1);
        exampleSet.getExampleTable().addAttribute(mergedAttribute);
        exampleSet.getAttributes().addRegular(mergedAttribute);
        for (Example example : exampleSet) {
            double firstValue = example.getValue(firstAttribute);
            double secondValue = example.getValue(secondAttribute);
            if (Double.isNaN(firstValue) || Double.isNaN(secondValue)) {
                example.setValue(mergedAttribute, Double.NaN);
                continue;
            }
            String firstValueString = example.getValueAsString(firstAttribute);
            String secondValueString = example.getValueAsString(secondAttribute);
            String mergedValueString = null;
            mergedValueString = trimValues ? String.valueOf(firstValueString.trim()) + separatorString.trim() + secondValueString.trim() : String.valueOf(firstValueString) + separatorString + secondValueString;
            double mergedValue = mergedAttribute.getMapping().mapString(mergedValueString);
            example.setValue(mergedAttribute, mergedValue);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_FIRST_ATTRIBUTE, "The first attribute of this merger.", false));
        types.add(new ParameterTypeString(PARAMETER_SECOND_ATTRIBUTE, "The second attribute of this merger.", false));
        types.add(new ParameterTypeString(PARAMETER_SEPARATOR, "Indicated a string which is used as separation of both values.", "_"));
        types.add(new ParameterTypeBoolean(PARAMETER_TRIM_VALUES, "Indicates if the two values should be trimmed, i.e. leading and trailing whitespaces should be removed, before the merge is performed.", false));
        return types;
    }
}

