/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;

public class KernelEpanechnikov
extends Kernel {
    private static final long serialVersionUID = -2375190740988942684L;
    private double sigma = 1.0;
    private double degree = 1.0;

    public String toString() {
        return "epanechnikov(s=" + this.sigma + ",d=" + this.degree + ")";
    }

    public void setParameters(double sigma, double degree) {
        this.sigma = sigma;
        this.degree = degree;
    }

    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double expression = this.norm2(x_index, x_att, y_index, y_att) / this.sigma;
        if (expression > 1.0) {
            return 0.0;
        }
        double minus = 1.0 - expression;
        return Math.pow(minus, this.degree);
    }

    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer("pow((1 - (");
        boolean first = true;
        int i = 0;
        while (i < x.length) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                result.append(String.valueOf(valueString) + " * " + valueString);
            } else {
                result.append(" + " + valueString + " * " + valueString);
            }
            first = false;
            ++i;
        }
        result.append(")), " + this.degree + ")");
        return result.toString();
    }
}

