/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.evosvm;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.SimplePlotterDialog;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.operator.learner.functions.kernel.evosvm.ClassificationOptimizationFunction;
import com.rapidminer.operator.learner.functions.kernel.evosvm.EvoSVMModel;
import com.rapidminer.operator.learner.functions.kernel.evosvm.OptimizationFunction;
import com.rapidminer.operator.learner.functions.kernel.evosvm.RegressionOptimizationFunction;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.kernels.Kernel;
import com.rapidminer.tools.math.optimization.ec.pso.PSOOptimization;
import java.util.ArrayList;
import java.util.Iterator;

public class PSOSVMOptimization
extends PSOOptimization {
    private static final double IS_ZERO = 1.0E-10;
    private ExampleSet exampleSet;
    private Kernel kernel;
    private double c;
    private double epsilon = 0.0;
    private double[] ys;
    private OptimizationFunction optimizationFunction;
    private boolean showPlot = false;
    private DataTable dataTable;
    private SimplePlotterDialog plotter;

    public PSOSVMOptimization(ExampleSet exampleSet, Kernel kernel, double c, int maxIterations, int generationsWithoutImprovement, int popSize, double inertiaWeight, double localWeight, double globalWeight, boolean dynamicInertiaWeight, boolean showPlot, RandomGenerator random) {
        super(popSize < 1 ? exampleSet.size() : popSize, exampleSet.size(), maxIterations, generationsWithoutImprovement, inertiaWeight, localWeight, globalWeight, 0.0, 1.0, dynamicInertiaWeight, random);
        this.exampleSet = exampleSet;
        this.kernel = kernel;
        this.kernel.init(exampleSet);
        this.c = c;
        if (this.c <= 0.0) {
            this.c = 0.0;
            int i = 0;
            while (i < exampleSet.size()) {
                this.c += kernel.getDistance(i, i);
                ++i;
            }
            this.c = (double)exampleSet.size() / this.c;
            exampleSet.getLog().log("Determine probably good value for C: set to " + this.c);
        }
        this.setMinValue(0.0);
        this.setMaxValue(this.c);
        this.ys = new double[exampleSet.size()];
        Iterator reader = exampleSet.iterator();
        int index = 0;
        Attribute label = exampleSet.getAttributes().getLabel();
        boolean regression = !label.isNominal() && label.getMapping().size() != 2;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            if (!regression) {
                this.ys[index++] = example.getLabel() == (double)label.getMapping().getPositiveIndex() ? 1.0 : -1.0;
                continue;
            }
            this.ys[index++] = example.getLabel();
        }
        this.optimizationFunction = !regression ? new ClassificationOptimizationFunction(false) : new RegressionOptimizationFunction(this.epsilon);
        this.showPlot = showPlot;
        if (showPlot) {
            this.dataTable = new SimpleDataTable("Fitness vs. Generations", new String[]{"Generations", "Best Fitness", "Current Fitness"});
            this.plotter = new SimplePlotterDialog(this.dataTable, false);
            this.plotter.setXAxis(0);
            this.plotter.plotColumn(1, true);
            this.plotter.plotColumn(2, true);
            this.plotter.setVisible(true);
        }
    }

    public void nextIteration() {
        if (this.showPlot) {
            this.dataTable.add(new SimpleDataTableRow(new double[]{this.getGeneration(), this.getBestFitnessEver(), this.getBestFitnessInGeneration()}));
        }
    }

    public PerformanceVector evaluateIndividual(double[] individual) {
        double fitness = this.optimizationFunction.getFitness(individual, this.ys, this.kernel)[0];
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("SVMOptValue", fitness, 1, false));
        return result;
    }

    public EvoSVMModel getModel(double[] alphas) {
        if (this.showPlot) {
            this.plotter.dispose();
        }
        Iterator reader = this.exampleSet.iterator();
        ArrayList<SupportVector> supportVectors = new ArrayList<SupportVector>();
        int index = 0;
        while (reader.hasNext()) {
            double currentAlpha = alphas[index];
            Example currentExample = (Example)reader.next();
            if (currentAlpha != 0.0) {
                double[] x = new double[this.exampleSet.getAttributes().size()];
                int a = 0;
                for (Attribute attribute : this.exampleSet.getAttributes()) {
                    x[a++] = currentExample.getValue(attribute);
                }
                supportVectors.add(new SupportVector(x, this.ys[index], currentAlpha));
            }
            ++index;
        }
        double[] sum = new double[this.exampleSet.size()];
        reader = this.exampleSet.iterator();
        index = 0;
        while (reader.hasNext()) {
            Example current = (Example)reader.next();
            double[] x = new double[this.exampleSet.getAttributes().size()];
            int a = 0;
            for (Attribute attribute : this.exampleSet.getAttributes()) {
                x[a++] = current.getValue(attribute);
            }
            sum[index] = this.kernel.getSum(supportVectors, x);
            ++index;
        }
        double bSum = 0.0;
        int bCounter = 0;
        int i = 0;
        while (i < alphas.length) {
            if (this.ys[i] * alphas[i] - this.c < -1.0E-10 && this.ys[i] * alphas[i] > 1.0E-10) {
                bSum += this.ys[i] - sum[i] - this.epsilon;
                ++bCounter;
            } else if (this.ys[i] * alphas[i] + this.c > 1.0E-10 && this.ys[i] * alphas[i] < -1.0E-10) {
                bSum += this.ys[i] - sum[i] - this.epsilon;
                ++bCounter;
            }
            ++i;
        }
        if (bCounter == 0) {
            bSum = 0.0;
            i = 0;
            while (i < alphas.length) {
                if (this.ys[i] * alphas[i] < 1.0E-10 && this.ys[i] * alphas[i] > -1.0E-10) {
                    bSum += this.ys[i] - sum[i];
                    ++bCounter;
                }
                ++i;
            }
            if (bCounter == 0) {
                bSum = 0.0;
                i = 0;
                while (i < alphas.length) {
                    bSum += this.ys[i] - sum[i];
                    ++bCounter;
                    ++i;
                }
            }
        }
        return new EvoSVMModel(this.exampleSet, supportVectors, this.kernel, bSum / (double)bCounter);
    }
}

