/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.functions.kernel.KernelModel;
import com.rapidminer.operator.learner.functions.kernel.RVMModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.operator.learner.functions.kernel.gaussianprocess.Model;

public class GPModel
extends KernelModel {
    private static final long serialVersionUID = 6094706651995436944L;
    private Model model = null;

    public GPModel(ExampleSet exampleSet, Model model) {
        super(exampleSet);
        this.model = model;
    }

    public boolean isClassificationModel() {
        return this.getLabel().isNominal();
    }

    public double getBias() {
        return 0.0;
    }

    public SupportVector getSupportVector(int index) {
        return null;
    }

    public double getAlpha(int index) {
        return Double.NaN;
    }

    public String getId(int index) {
        return null;
    }

    public int getNumberOfSupportVectors() {
        return this.model.getNumberOfBasisVectors();
    }

    public int getNumberOfAttributes() {
        return this.model.getInputDim();
    }

    public double getAttributeValue(int exampleIndex, int attributeIndex) {
        return this.model.getBasisVectorValue(exampleIndex, attributeIndex);
    }

    public String getClassificationLabel(int index) {
        return "?";
    }

    public double getRegressionLabel(int index) {
        return Double.NaN;
    }

    public double getFunctionValue(int index) {
        return this.model.applyToVector(this.model.getBasisVector(index));
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        for (Example e : exampleSet) {
            double functionValue = this.model.applyToVector(RVMModel.makeInputVector(e));
            if (this.getLabel().isNominal()) {
                if (functionValue > 0.0) {
                    e.setValue(predictedLabel, this.getLabel().getMapping().getPositiveIndex());
                } else {
                    e.setValue(predictedLabel, this.getLabel().getMapping().getNegativeIndex());
                }
                e.setConfidence(predictedLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-functionValue)));
                e.setConfidence(predictedLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(functionValue)));
                continue;
            }
            e.setValue(predictedLabel, functionValue);
        }
        return exampleSet;
    }
}

