/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.ComponentWeightsCreatable;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentWeights
extends Operator {
    public static final String PARAMETER_NORMALIZE_WEIGHTS = "normalize_weights";
    public static final String PARAMETER_COMPONENT_NUMBER = "component_number";
    private static final Class[] INPUT_CLASSES = new Class[]{Model.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{Model.class, AttributeWeights.class};

    public ComponentWeights(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Model model = this.getInput(Model.class);
        if (!(model instanceof ComponentWeightsCreatable)) {
            throw new OperatorException(String.valueOf(this.getName()) + ": needs an input model wich implements the ComponentWeightsCreatable interface:" + model.getClass().getName());
        }
        int component = this.getParameterAsInt(PARAMETER_COMPONENT_NUMBER);
        AttributeWeights weights = ((ComponentWeightsCreatable)((Object)model)).getWeightsOfComponent(component);
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS)) {
            weights.normalize();
        }
        return new IOObject[]{model, weights};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE_WEIGHTS, "Activates the normalization of all weights.", false));
        list.add(new ParameterTypeInt(PARAMETER_COMPONENT_NUMBER, "Create the weights of this component.", 1, Integer.MAX_VALUE, 1));
        return list;
    }
}

