/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductGenerationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_FIRST_ATTRIBUTE_NAME = "first_attribute_name";
    public static final String PARAMETER_SECOND_ATTRIBUTE_NAME = "second_attribute_name";

    public ProductGenerationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        String firstAttributeName = this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE_NAME);
        String secondAttributeName = this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE_NAME);
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical() || !attribute.getName().matches(firstAttributeName)) continue;
            for (Attribute attribute2 : exampleSet.getAttributes()) {
                if (!attribute2.isNumerical() || !attribute2.getName().matches(secondAttributeName)) continue;
                newAttributes.add(this.createAttribute(exampleSet, attribute, attribute2));
            }
        }
        for (Attribute attribute : newAttributes) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    private Attribute createAttribute(ExampleSet exampleSet, Attribute attribute1, Attribute attribute2) {
        Attribute result = AttributeFactory.createAttribute("(" + attribute1.getConstruction().toString() + ") * (" + attribute2.getConstruction().toString() + ")", 4);
        exampleSet.getExampleTable().addAttribute(result);
        for (Example example : exampleSet) {
            double value1 = example.getValue(attribute1);
            double value2 = example.getValue(attribute2);
            double resultValue = value1 * value2;
            example.setValue(result, resultValue);
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_FIRST_ATTRIBUTE_NAME, "The name(s) of the first attribute to be multiplied (regular expression possible).", false));
        types.add(new ParameterTypeString(PARAMETER_SECOND_ATTRIBUTE_NAME, "The name(s) of the second attribute to be multiplied (regular expression possible).", false));
        return types;
    }
}

