/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearCombinationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_KEEP_ALL = "keep_all";

    public LinearCombinationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) continue;
            throw new UserError((Operator)this, 104, "Linear Combination", attribute.getName());
        }
        Attribute newAttribute = AttributeFactory.createAttribute("linear_combination", 4);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example example : exampleSet) {
            double valueSum = 0.0;
            for (Attribute attribute : example.getAttributes()) {
                if (attribute.equals(newAttribute)) continue;
                valueSum += example.getValue(attribute);
            }
            example.setValue(newAttribute, valueSum);
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            exampleSet.getAttributes().clearRegular();
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "Indicates if the all old attributes should be kept.", false));
        return types;
    }
}

