/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLExecution
extends Operator {
    public static final String PARAMETER_DATABASE_SYSTEM = "database_system";
    public static final String PARAMETER_DATABASE_URL = "database_url";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_QUERY = "query";
    public static final String PARAMETER_QUERY_FILE = "query_file";

    public SQLExecution(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        try {
            DatabaseHandler databaseHandler = this.getConnectedDatabaseHandler();
            String query = this.getQuery();
            this.log("Executing query: '" + query + "'");
            Statement statement = databaseHandler.createStatement(false);
            statement.execute(query);
            this.log("Query executed.");
            statement.close();
            databaseHandler.disconnect();
        }
        catch (SQLException sqle) {
            throw new UserError((Operator)this, (Throwable)sqle, 304, sqle.getMessage());
        }
        return new IOObject[0];
    }

    protected DatabaseHandler getConnectedDatabaseHandler() throws OperatorException, SQLException {
        String databaseURL = this.getParameterAsString(PARAMETER_DATABASE_URL);
        String username = this.getParameterAsString(PARAMETER_USERNAME);
        String password = this.getParameterAsString(PARAMETER_PASSWORD);
        return DatabaseHandler.getConnectedDatabaseHandler(databaseURL, username, password, DatabaseService.getJDBCProperties().get(this.getParameterAsInt(PARAMETER_DATABASE_SYSTEM)), this);
    }

    private String getQuery() throws OperatorException {
        String query = this.getParameterAsString(PARAMETER_QUERY);
        if (query != null) {
            query = query.trim();
        }
        String parameterUsed = null;
        boolean warning = false;
        if (query == null || query.length() == 0) {
            File queryFile = this.getParameterAsFile(PARAMETER_QUERY_FILE);
            if (queryFile != null) {
                try {
                    query = Tools.readTextFile(queryFile);
                    parameterUsed = PARAMETER_QUERY_FILE;
                }
                catch (IOException ioe) {
                    throw new UserError((Operator)this, (Throwable)ioe, 302, queryFile, ioe.getMessage());
                }
                if (query == null || query.trim().length() == 0) {
                    throw new UserError((Operator)this, 205, queryFile);
                }
            }
        } else {
            parameterUsed = PARAMETER_QUERY;
            if (this.isParameterSet(PARAMETER_QUERY_FILE)) {
                warning = true;
            }
        }
        if (query == null) {
            throw new UserError((Operator)this, 202, PARAMETER_QUERY, PARAMETER_QUERY_FILE, "table_name");
        }
        if (warning) {
            this.logWarning("Only one of the parameters 'query' and 'query_file' has to be set. Using value of '" + parameterUsed + "'.");
        }
        return query;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_DATABASE_SYSTEM, "Indicates the used database system", DatabaseService.getDBSystemNames(), 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_DATABASE_URL, "The complete URL connection string for the database, e.g. 'jdbc:mysql://foo.bar:portnr/database'", false));
        types.add(new ParameterTypeString(PARAMETER_USERNAME, "Database username.", false));
        types.add(new ParameterTypePassword(PARAMETER_PASSWORD, "Password for the database."));
        type = new ParameterTypeText(PARAMETER_QUERY, "SQL query. If not set, the query is read from the file specified by 'query_file'.", TextType.SQL);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_QUERY_FILE, "File containing the query. Only evaluated if 'query' is not set.", null, true));
        return types;
    }
}

