/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.MetaDataViewerTable;
import com.rapidminer.gui.viewer.MetaDataViewerTableModel;
import com.rapidminer.report.Tableable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MetaDataViewer
extends JPanel
implements Tableable {
    private static final String MENU_ICON_NAME = "24/navigate_close.png";
    private static Icon menuIcon = null;
    private static final long serialVersionUID = 5466205420267797125L;
    private JLabel generalInfo = new JLabel();
    private MetaDataViewerTable metaDataTable = new MetaDataViewerTable();

    static {
        menuIcon = SwingTools.createIcon(MENU_ICON_NAME);
    }

    public MetaDataViewer(ExampleSet exampleSet, boolean showOptions) {
        super(new BorderLayout());
        JPanel infoPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        infoPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(this.generalInfo, c);
        infoPanel.add(this.generalInfo);
        if (showOptions) {
            final JButton optionMenuButton = menuIcon != null ? new JButton("", menuIcon){
                private static final long serialVersionUID = 5070388716887885349L;

                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.width = 24;
                    return dim;
                }
            } : new JButton("Menu");
            optionMenuButton.setToolTipText("Shows additional options for this view.");
            optionMenuButton.addMouseListener(new MouseListener(){

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseClicked(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                    JPopupMenu menu = new JPopupMenu();
                    int i = 0;
                    while (i < MetaDataViewerTableModel.COLUMN_NAMES.length) {
                        menu.add(new ToggleShowColumnItem(MetaDataViewerTableModel.COLUMN_NAMES[i], i, MetaDataViewer.this.metaDataTable.getMetaDataModel().getShowColumn(i), MetaDataViewer.this.metaDataTable));
                        ++i;
                    }
                    menu.add(new CalculateStatisticsItem(MetaDataViewer.this.metaDataTable.getMetaDataModel()));
                    menu.show(optionMenuButton, e.getX(), e.getY());
                }
            });
            JPanel optionButtonPanel = new JPanel(new FlowLayout(2));
            optionButtonPanel.add(optionMenuButton);
            c.weightx = 0.0;
            c.gridwidth = 0;
            layout.setConstraints(optionButtonPanel, c);
            infoPanel.add(optionButtonPanel);
        }
        this.add((Component)infoPanel, "North");
        ExtendedJScrollPane tableScrollPane = new ExtendedJScrollPane(this.metaDataTable);
        this.add((Component)tableScrollPane, "Center");
        this.setExampleSet(exampleSet);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        if (exampleSet != null) {
            StringBuffer infoText = new StringBuffer("ExampleSet (");
            int noExamples = exampleSet.size();
            infoText.append(noExamples);
            infoText.append(noExamples == 1 ? " example, " : " examples, ");
            int noSpecial = exampleSet.getAttributes().specialSize();
            infoText.append(noSpecial);
            infoText.append(noSpecial == 1 ? " special attribute, " : " special attributes, ");
            int noRegular = exampleSet.getAttributes().size();
            infoText.append(noRegular);
            infoText.append(noRegular == 1 ? " regular attribute)" : " regular attributes)");
            this.generalInfo.setText(infoText.toString());
            this.metaDataTable.setExampleSet(exampleSet);
        } else {
            this.generalInfo.setText("no examples");
            this.metaDataTable.setExampleSet(null);
        }
    }

    public void prepareReporting() {
        this.metaDataTable.prepareReporting();
    }

    public void finishReporting() {
        this.metaDataTable.finishReporting();
    }

    public String getColumnName(int columnIndex) {
        return this.metaDataTable.getColumnName(columnIndex);
    }

    public String getCell(int row, int column) {
        return this.metaDataTable.getCell(row, column);
    }

    public int getColumnNumber() {
        return this.metaDataTable.getColumnNumber();
    }

    public int getRowNumber() {
        return this.metaDataTable.getRowNumber();
    }

    public boolean isFirstLineHeader() {
        return false;
    }

    public boolean isFirstColumnHeader() {
        return false;
    }

    private static class CalculateStatisticsItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 6114799407333674792L;
        private static final String ICON_NAME = "calculator.png";
        private static final Icon ICON = SwingTools.createIcon("24/calculator.png");
        private MetaDataViewerTableModel metaDataModel;

        public CalculateStatisticsItem(MetaDataViewerTableModel metaDataModel) {
            super("Calculate Statistics (might take time)", ICON);
            this.metaDataModel = metaDataModel;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.metaDataModel.calculateStatistics();
        }
    }

    private static class ToggleShowColumnItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 570766967933245379L;
        private int index;
        private MetaDataViewerTable metaDataTable;

        ToggleShowColumnItem(String name, int index, boolean state, MetaDataViewerTable metaDataTable) {
            super("Show column '" + name + "'", state);
            this.setToolTipText("Toggles if the column with name '" + name + "' should be displayed");
            this.addActionListener(this);
            this.index = index;
            this.metaDataTable = metaDataTable;
        }

        public void actionPerformed(ActionEvent e) {
            this.metaDataTable.getMetaDataModel().setShowColumn(this.index, this.isSelected());
        }
    }
}

