/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.Version;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;

public class CheckForUpdatesThread
extends Thread {
    private static final String[] VERSION_URLS = new String[]{"http://www.rapid-i.com/versions/rapidminer/version.txt", "http://www.rapid-i.com/versions/yale/version.txt", "http://www-ai.cs.uni-dortmund.de/SOFTWARE/YALE/version.txt"};
    private boolean showFailureDialog = false;
    private MainFrame mainFrame;

    public CheckForUpdatesThread(MainFrame mainFrame, boolean dialog) {
        this.mainFrame = mainFrame;
        this.showFailureDialog = dialog;
    }

    public void run() {
        LinkedList<String> remoteVersions = new LinkedList<String>();
        String[] stringArray = VERSION_URLS;
        int n = VERSION_URLS.length;
        int n2 = 0;
        while (n2 < n) {
            block24: {
                String s = stringArray[n2];
                URL url = null;
                try {
                    url = new URL(s);
                }
                catch (MalformedURLException e) {
                    LogService.getGlobal().log("Cannot create update target url: " + e.getMessage(), 6);
                }
                if (url != null) {
                    BufferedReader in = null;
                    try {
                        try {
                            in = new BufferedReader(new InputStreamReader(url.openStream()));
                            String remoteVersion = in.readLine();
                            if (remoteVersion != null && remoteVersion.length() > 0 && Character.isDigit(remoteVersion.charAt(0))) {
                                remoteVersions.add(remoteVersion);
                            }
                        }
                        catch (IOException e) {
                            LogService.getGlobal().log("Not able to check for updates. Maybe no internet connection.", 5);
                            try {
                                if (in != null) {
                                    in.close();
                                }
                                break block24;
                            }
                            catch (IOException e2) {
                                throw new Error(e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            throw new Error(e);
                        }
                        throw throwable;
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
            }
            ++n2;
        }
        if (remoteVersions.size() > 0) {
            RapidMinerGUI.saveLastUpdateCheckDate();
        }
        Iterator i = remoteVersions.iterator();
        VersionNumber newestVersion = this.getVersionNumber(Version.getLongVersion());
        while (i.hasNext()) {
            VersionNumber remoteVersion;
            String remoteVersionString = (String)i.next();
            if (remoteVersionString == null || !this.isNewer(remoteVersion = this.getVersionNumber(remoteVersionString), newestVersion)) continue;
            newestVersion = remoteVersion;
        }
        if (newestVersion != null && this.isNewer(newestVersion, this.getVersionNumber(Version.getLongVersion()))) {
            JOptionPane.showMessageDialog(this.mainFrame, "New version of the RapidMiner Community Edition is available:" + Tools.getLineSeparator() + Tools.getLineSeparator() + "          RapidMiner " + newestVersion + Tools.getLineSeparator() + Tools.getLineSeparator() + "Please download it from:" + Tools.getLineSeparator() + "          http://www.rapidminer.com", "New RapidMiner version", 1);
        } else if (this.showFailureDialog) {
            JOptionPane.showMessageDialog(this.mainFrame, "No newer versions of the RapidMiner Community Edition available!", "RapidMiner CE is up to date", 1);
        }
    }

    private VersionNumber getVersionNumber(String versionString) {
        return new VersionNumber(versionString);
    }

    private boolean isNewer(VersionNumber remoteVersion, VersionNumber newestVersion) {
        return remoteVersion.compareTo(newestVersion) > 0;
    }
}

