/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look;

import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.look.RoundedPopupFactory;
import com.rapidminer.gui.look.borders.Borders;
import com.rapidminer.gui.look.icons.IconFactory;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class RapidLookAndFeel
extends BasicLookAndFeel {
    private static final long serialVersionUID = 1616331528047010458L;
    private static final Colors COLORS = new Colors();

    public static Colors getColors() {
        return COLORS;
    }

    public void initialize() {
        super.initialize();
        RoundedPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        RoundedPopupFactory.uninstall();
    }

    public UIDefaults getDefaults() {
        RapidLookAndFeel.getColors();
        UIDefaults table = new UIDefaults();
        this.initClassDefaults(table);
        this.initSystemColorDefaults(table);
        this.initComponentDefaults(table);
        COLORS.addCustomEntriesToTable(table);
        return table;
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public String getDescription() {
        return "RapidLook Look And Feel";
    }

    public String getID() {
        return "RapidLook";
    }

    public String getName() {
        return "RapidLook Look And Feel";
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        Object[] systemColors = new Object[]{"desktop", RapidLookAndFeel.getDesktopColor(), "activeCaption", RapidLookAndFeel.getWindowTitleBackground(), "activeCaptionText", RapidLookAndFeel.getWindowTitleForeground(), "activeCaptionBorder", RapidLookAndFeel.getPrimaryControlShadow(), "inactiveCaption", RapidLookAndFeel.getWindowTitleBackground(), "inactiveCaptionText", RapidLookAndFeel.getWindowTitleForeground(), "inactiveCaptionBorder", RapidLookAndFeel.getControlShadow(), "window", RapidLookAndFeel.getColors().getCommonBackground(), "windowBorder", RapidLookAndFeel.getColors().getCommonBackground(), "windowText", RapidLookAndFeel.getUserTextColor(), "menu", RapidLookAndFeel.getMenuBackground(), "menuText", RapidLookAndFeel.getMenuForeground(), "text", RapidLookAndFeel.getTextBackground(), "textText", RapidLookAndFeel.getUserTextColor(), "textHighlight", this.getTextHighlightColor(), "textHighlightText", RapidLookAndFeel.getHighlightedTextColor(), "textInactiveText", RapidLookAndFeel.getInactiveSystemTextColor(), "control", RapidLookAndFeel.getColors().getCommonBackground(), "controlText", RapidLookAndFeel.getControlTextColor(), "controlHighlight", RapidLookAndFeel.getControlHighlight(), "controlLtHighlight", RapidLookAndFeel.getControlHighlight(), "controlShadow", RapidLookAndFeel.getControlShadow(), "controlDkShadow", RapidLookAndFeel.getControlDarkShadow(), "scrollbar", RapidLookAndFeel.getColors().getCommonBackground(), "info", new ColorUIResource(255, 240, 195)};
        int i = 0;
        while (i < systemColors.length) {
            table.put(systemColors[i], systemColors[i + 1]);
            i += 2;
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        UIDefaults.ProxyLazyValue toolTipBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{new ColorUIResource(100, 100, 100)});
        UIDefaults.ProxyLazyValue focusCellHighlightBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{COLORS.getTextHighlightBackColor().darker()});
        UIDefaults.ProxyLazyValue fontDialog12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", 0, 12});
        ColorUIResource caretColor = new ColorUIResource(0, 25, 100);
        InsetsUIResource textFieldMargin = new InsetsUIResource(4, 6, 4, 6);
        InsetsUIResource tabbedpaneTabInsets = new InsetsUIResource(3, 10, 0, 10);
        ImageIcon defaultDirectoryIcon = SwingTools.createImage("plaf/folder.png");
        Integer zero = 0;
        Integer one = 1;
        InsetsUIResource sliderFocusInsets = new InsetsUIResource(2, 2, 2, 2);
        Object[] objectArray = new Object[384];
        objectArray[0] = "Button.font";
        objectArray[1] = fontDialog12;
        objectArray[2] = "Button.background";
        objectArray[3] = COLORS.getCommonBackground();
        objectArray[4] = "Button.foreground";
        objectArray[5] = COLORS.getCommonForeground();
        objectArray[6] = "Button.margin";
        objectArray[7] = new InsetsUIResource(10, 20, 10, 20);
        objectArray[8] = "Button.textShiftOffset";
        objectArray[9] = one;
        objectArray[10] = "Button.focusInputMap";
        objectArray[11] = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"});
        objectArray[12] = "ToggleButton.font";
        objectArray[13] = fontDialog12;
        objectArray[14] = "ToggleButton.background";
        objectArray[15] = COLORS.getCommonBackground();
        objectArray[16] = "ToggleButton.foreground";
        objectArray[17] = COLORS.getCommonForeground();
        objectArray[18] = "ToggleButton.textShiftOffset";
        objectArray[19] = one;
        objectArray[20] = "ToggleButton.margin";
        objectArray[21] = textFieldMargin;
        objectArray[22] = "Button.focusInputMap";
        objectArray[23] = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"});
        objectArray[24] = "RadioButton.font";
        objectArray[25] = fontDialog12;
        objectArray[26] = "RadioButton.background";
        objectArray[27] = COLORS.getCommonBackground();
        objectArray[28] = "RadioButton.foreground";
        objectArray[29] = COLORS.getCommonForeground();
        objectArray[30] = "RadioButton.textShiftOffset";
        objectArray[31] = zero;
        objectArray[32] = "RadioButton.focusInputMap";
        objectArray[33] = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed"});
        objectArray[34] = "CheckBox.font";
        objectArray[35] = fontDialog12;
        objectArray[36] = "CheckBox.background";
        objectArray[37] = COLORS.getCommonBackground();
        objectArray[38] = "CheckBox.foreground";
        objectArray[39] = COLORS.getCommonForeground();
        objectArray[40] = "CheckBox.textShiftOffset";
        objectArray[41] = zero;
        objectArray[42] = "CheckBox.focusInputMap";
        objectArray[43] = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed"});
        objectArray[44] = "ComboBox.font";
        objectArray[45] = fontDialog12;
        objectArray[46] = "ComboBox.background";
        objectArray[47] = COLORS.getCommonBackground();
        objectArray[48] = "ComboBox.foreground";
        objectArray[49] = COLORS.getCommonForeground();
        objectArray[50] = "ComboBox.textShiftOffset";
        objectArray[51] = one;
        objectArray[52] = "ComboBox.disabledForeground";
        objectArray[53] = RapidLookAndFeel.getInactiveSystemTextColor();
        objectArray[54] = "ComboBox.ancestorInputMap";
        objectArray[55] = new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"});
        objectArray[56] = "FileChooser.defaultDirectoryIcon";
        objectArray[57] = defaultDirectoryIcon;
        objectArray[58] = "FileChooser.newFolderIcon";
        objectArray[60] = "FileChooser.upFolderIcon";
        objectArray[62] = "FileChooser.homeFolderIcon";
        objectArray[64] = "FileChooser.detailsViewIcon";
        objectArray[66] = "FileChooser.listViewIcon";
        objectArray[68] = "FileView.directoryIcon";
        objectArray[70] = "FileView.fileIcon";
        objectArray[72] = "FileView.computerIcon";
        objectArray[74] = "FileView.hardDriveIcon";
        objectArray[76] = "FileView.floppyDriveIcon";
        objectArray[78] = "FileChooser.ChangeViewNormalIcon";
        objectArray[79] = SwingTools.createImage("plaf/fc/fc_change_1.png");
        objectArray[80] = "FileChooser.ChangeViewHighlightedIcon";
        objectArray[81] = SwingTools.createImage("plaf/fc/fc_change_2.png");
        objectArray[82] = "FileChooser.BookmarksAddNormalIcon";
        objectArray[83] = SwingTools.createImage("plaf/fc/fc_bookmark_1.png");
        objectArray[84] = "FileChooser.BookmarksAddHighlightedIcon";
        objectArray[85] = SwingTools.createImage("plaf/fc/fc_bookmark_2.png");
        objectArray[86] = "FileChooser.HomeNormalIcon";
        objectArray[87] = SwingTools.createImage("plaf/fc/fc_home_1.png");
        objectArray[88] = "FileChooser.HomeHighlightedIcon";
        objectArray[89] = SwingTools.createImage("plaf/fc/fc_home_2.png");
        objectArray[90] = "FileChooser.HomeDisabledIcon";
        objectArray[91] = SwingTools.createImage("plaf/fc/fc_home_3.png");
        objectArray[92] = "FileChooser.NewFolderNormalIcon";
        objectArray[93] = SwingTools.createImage("plaf/fc/fc_new_1.png");
        objectArray[94] = "FileChooser.NewFolderHighlightedIcon";
        objectArray[95] = SwingTools.createImage("plaf/fc/fc_new_2.png");
        objectArray[96] = "FileChooser.NewFolderDisabledIcon";
        objectArray[97] = SwingTools.createImage("plaf/fc/fc_new_3.png");
        objectArray[98] = "FileChooser.UpFolderNormalIcon";
        objectArray[99] = SwingTools.createImage("plaf/fc/fc_up_1.png");
        objectArray[100] = "FileChooser.UpFolderHighlightedIcon";
        objectArray[101] = SwingTools.createImage("plaf/fc/fc_up_2.png");
        objectArray[102] = "FileChooser.UpFolderDisabledIcon";
        objectArray[103] = SwingTools.createImage("plaf/fc/fc_up_3.png");
        objectArray[104] = "FileChooser.BackFolderNormalIcon";
        objectArray[105] = SwingTools.createImage("plaf/fc/fc_back1.png");
        objectArray[106] = "FileChooser.BackFolderHighlightedIcon";
        objectArray[107] = SwingTools.createImage("plaf/fc/fc_back2.png");
        objectArray[108] = "FileChooser.BackFolderDisabledIcon";
        objectArray[109] = SwingTools.createImage("plaf/fc/fc_back3.png");
        objectArray[110] = "FileChooser.ancestorInputMap";
        objectArray[111] = new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "BACK_SPACE", "Go Up", "ENTER", "approveSelection"});
        objectArray[112] = "InternalFrame.titleFont";
        objectArray[113] = new FontUIResource("Dialog", 1, 14);
        objectArray[114] = "InternalFrame.activeTitleForeground";
        objectArray[115] = Colors.getWhite();
        objectArray[116] = "InternalFrame.inactiveTitleForeground";
        objectArray[117] = Colors.getWhite();
        objectArray[118] = "InternalFrame.closeIcon";
        objectArray[119] = SwingTools.createImage("plaf/close_icon.png");
        objectArray[120] = "InternalFrame.rolloverCloseIcon";
        objectArray[121] = SwingTools.createImage("plaf/armed_close_icon.png");
        objectArray[122] = "InternalFrame.maximizeIcon";
        objectArray[123] = SwingTools.createImage("plaf/maximize_icon.png");
        objectArray[124] = "InternalFrame.rolloverMaximizeIcon";
        objectArray[125] = SwingTools.createImage("plaf/armed_maximize_icon.png");
        objectArray[126] = "InternalFrame.minimizeIcon";
        objectArray[127] = SwingTools.createImage("plaf/minimize_icon.png");
        objectArray[128] = "InternalFrame.rolloverMinimizeIcon";
        objectArray[129] = SwingTools.createImage("plaf/armed_minimize_icon.png");
        objectArray[130] = "InternalFrame.iconifyIcon";
        objectArray[131] = SwingTools.createImage("plaf/iconify_icon.png");
        objectArray[132] = "InternalFrame.rolloverIconifyIcon";
        objectArray[133] = SwingTools.createImage("plaf/armed_iconify_icon.png");
        objectArray[134] = "InternalFrame.icon";
        objectArray[135] = SwingTools.createImage("plaf/internal_icon.png");
        objectArray[136] = "DesktopIcon.foreground";
        objectArray[137] = RapidLookAndFeel.getControlTextColor();
        objectArray[138] = "DesktopIcon.width";
        objectArray[139] = new Integer(140);
        objectArray[140] = "DesktopIcon.font";
        objectArray[141] = RapidLookAndFeel.getMainFont();
        objectArray[142] = "Desktop.background";
        objectArray[143] = COLORS.getDesktopBackgroundColor();
        objectArray[144] = "Desktop.ancestorInputMap";
        objectArray[145] = new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "shift RIGHT", "shrinkRight", "shift KP_RIGHT", "shrinkRight", "LEFT", "left", "KP_LEFT", "left", "shift LEFT", "shrinkLeft", "shift KP_LEFT", "shrinkLeft", "UP", "up", "KP_UP", "up", "shift UP", "shrinkUp", "shift KP_UP", "shrinkUp", "DOWN", "down", "KP_DOWN", "down", "shift DOWN", "shrinkDown", "shift KP_DOWN", "shrinkDown", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame", "ctrl F12", "navigateNext", "shift ctrl F12", "navigatePrevious"});
        objectArray[146] = "Label.font";
        objectArray[147] = fontDialog12;
        objectArray[148] = "Label.foreground";
        objectArray[149] = RapidLookAndFeel.getSystemTextColor();
        objectArray[150] = "Label.disabledForeground";
        objectArray[151] = RapidLookAndFeel.getInactiveSystemTextColor();
        objectArray[152] = "Label.background";
        objectArray[153] = COLORS.getCommonBackground();
        objectArray[154] = "List.focusCellHighlightBorder";
        objectArray[155] = focusCellHighlightBorder;
        objectArray[156] = "List.font";
        objectArray[157] = fontDialog12;
        objectArray[158] = "List.background";
        objectArray[159] = Colors.getWhite();
        objectArray[160] = "List.selectionBackground";
        objectArray[161] = COLORS.getTextHighlightBackColor();
        objectArray[162] = "List.focusInputMap";
        objectArray[163] = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection"});
        objectArray[164] = "MenuBar.font";
        objectArray[165] = fontDialog12;
        objectArray[166] = "MenuBar.windowBindings";
        objectArray[167] = new Object[]{"F10", "takeFocus"};
        objectArray[168] = "MenuItem.font";
        objectArray[169] = fontDialog12;
        objectArray[170] = "MenuItem.acceleratorFont";
        objectArray[171] = fontDialog12;
        objectArray[172] = "MenuItem.selectionBackground";
        objectArray[173] = RapidLookAndFeel.getMenuSelectedBack();
        objectArray[174] = "RadioButtonMenuItem.font";
        objectArray[175] = fontDialog12;
        objectArray[176] = "RadioButtonMenuItem.selectionBackground";
        objectArray[177] = RapidLookAndFeel.getMenuSelectedBack();
        objectArray[178] = "RadioButtonMenuItem.checkIcon";
        objectArray[179] = new UIDefaults.ProxyLazyValue("com.rapidminer.gui.look.icons.IconFactory", "getRadioButtonMenuItemIcon");
        objectArray[180] = "CheckBoxMenuItem.font";
        objectArray[181] = fontDialog12;
        objectArray[182] = "CheckBoxMenuItem.selectionBackground";
        objectArray[183] = RapidLookAndFeel.getMenuSelectedBack();
        objectArray[184] = "CheckBoxMenuItem.checkIcon";
        objectArray[185] = new UIDefaults.ProxyLazyValue("com.rapidminer.gui.look.icons.IconFactory", "getCheckBoxMenuItemIcon");
        objectArray[186] = "Menu.font";
        objectArray[187] = fontDialog12;
        objectArray[188] = "Menu.selectionBackground";
        objectArray[189] = RapidLookAndFeel.getMenuSelectedBack();
        objectArray[190] = "PopupMenu.font";
        objectArray[191] = fontDialog12;
        objectArray[192] = "OptionPane.font";
        objectArray[193] = fontDialog12;
        objectArray[194] = "OptionPane.informationIcon";
        objectArray[195] = SwingTools.createImage("plaf/information.png");
        objectArray[196] = "OptionPane.errorIcon";
        objectArray[197] = SwingTools.createImage("plaf/error.png");
        objectArray[198] = "OptionPane.questionIcon";
        objectArray[199] = SwingTools.createImage("plaf/question.png");
        objectArray[200] = "OptionPane.warningIcon";
        objectArray[201] = SwingTools.createImage("plaf/warning.png");
        objectArray[202] = "Panel.font";
        objectArray[203] = fontDialog12;
        objectArray[204] = "ProgressBar.foreground";
        objectArray[205] = new ColorUIResource(40, 40, 40);
        objectArray[206] = "ProgressBar.background";
        objectArray[207] = new ColorUIResource(240, 240, 240);
        objectArray[208] = "ProgressBar.font";
        objectArray[209] = new Font("Dialog", 0, 11);
        objectArray[210] = "ScrollBar.border";
        objectArray[212] = "ScrollBar.background";
        objectArray[213] = RapidLookAndFeel.getColors().getCommonBackground();
        objectArray[214] = "ScrollBar.focusInputMap";
        objectArray[215] = new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"});
        objectArray[216] = "ScrollPane.font";
        objectArray[217] = fontDialog12;
        objectArray[218] = "ScrollPane.ancestorInputMap";
        objectArray[219] = new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"});
        objectArray[220] = "Viewport.font";
        objectArray[221] = fontDialog12;
        objectArray[222] = "Slider.focusInsets";
        objectArray[223] = sliderFocusInsets;
        objectArray[224] = "Slider.disabledForeground";
        objectArray[225] = RapidLookAndFeel.getInactiveSystemTextColor();
        objectArray[226] = "Slider.majorColor";
        objectArray[227] = new ColorUIResource(100, 100, 100);
        objectArray[228] = "Slider.minorColor";
        objectArray[229] = new ColorUIResource(180, 180, 180);
        objectArray[230] = "Slider.majorDisabledColor";
        objectArray[231] = new ColorUIResource(180, 180, 180);
        objectArray[232] = "Slider.minorDisabledColor";
        objectArray[233] = new ColorUIResource(220, 220, 220);
        objectArray[234] = "Slider.trackWidth";
        objectArray[235] = new Integer(7);
        objectArray[236] = "Slider.majorTickLength";
        objectArray[237] = new Integer(6);
        objectArray[238] = "Slider.focusInputMap";
        objectArray[239] = new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "ctrl PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "ctrl PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"});
        objectArray[240] = "Spinner.font";
        objectArray[241] = fontDialog12;
        objectArray[242] = "Spinner.background";
        objectArray[243] = COLORS.getCommonBackground();
        objectArray[244] = "Spinner.margin";
        objectArray[245] = new InsetsUIResource(10, 10, 10, 10);
        objectArray[246] = "Spinner.ancestorInputMap";
        objectArray[247] = new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"});
        objectArray[248] = "SplitPane.dividerSize";
        objectArray[249] = new Integer(9);
        objectArray[250] = "SplitPane.highlight";
        objectArray[251] = new ColorUIResource(250, 250, 250);
        objectArray[252] = "SplitPane.shadow";
        objectArray[253] = new ColorUIResource(200, 200, 200);
        objectArray[254] = "SplitPane.ancestorInputMap";
        objectArray[255] = new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"});
        objectArray[256] = "SplitPaneDivider.border";
        objectArray[258] = "TabbedPane.tabAreaInsets";
        objectArray[259] = tabbedpaneTabInsets;
        objectArray[260] = "TabbedPane.font";
        objectArray[261] = fontDialog12;
        objectArray[262] = "TabbedPane.focusInputMap";
        objectArray[263] = new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"});
        objectArray[264] = "TabbedPane.ancestorInputMap";
        objectArray[265] = new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"});
        objectArray[266] = "Table.font";
        objectArray[267] = fontDialog12;
        objectArray[268] = "Table.background";
        objectArray[269] = Colors.getWhite();
        objectArray[270] = "Table.selectionForeground";
        objectArray[271] = RapidLookAndFeel.getUserTextColor();
        objectArray[272] = "Table.gridColor";
        objectArray[273] = new ColorUIResource(200, 200, 200);
        objectArray[274] = "Table.focusCellForeground";
        objectArray[275] = RapidLookAndFeel.getHighlightedTextColor();
        objectArray[276] = "Table.focusCellHighlightBorder";
        objectArray[277] = new BorderUIResource.LineBorderUIResource(COLORS.getTextHighlightBackColor().brighter());
        objectArray[278] = "Table.ancestorInputMap";
        objectArray[279] = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"});
        objectArray[280] = "TableHeader.font";
        objectArray[281] = fontDialog12;
        objectArray[282] = "TableHeader.background";
        objectArray[283] = RapidLookAndFeel.getColors().getCommonBackground();
        objectArray[284] = "TextField.margin";
        objectArray[285] = textFieldMargin;
        objectArray[286] = "TextField.font";
        objectArray[287] = fontDialog12;
        objectArray[288] = "TextField.caretForeground";
        objectArray[289] = caretColor;
        objectArray[290] = "TextField.focusInputMap";
        objectArray[291] = fieldInputMap;
        objectArray[292] = "TextField.background";
        objectArray[293] = Colors.getWhite();
        objectArray[294] = "FormattedTextField.margin";
        objectArray[295] = textFieldMargin;
        objectArray[296] = "FormattedTextField.font";
        objectArray[297] = fontDialog12;
        objectArray[298] = "FormattedTextField.caretForeground";
        objectArray[299] = caretColor;
        objectArray[300] = "FormattedTextField.background";
        objectArray[301] = RapidLookAndFeel.getWhiteBackground();
        objectArray[302] = "FormattedTextField.focusInputMap";
        objectArray[303] = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"});
        objectArray[304] = "PasswordField.margin";
        objectArray[305] = textFieldMargin;
        objectArray[306] = "PasswordField.font";
        objectArray[307] = fontDialog12;
        objectArray[308] = "PasswordField.caretForeground";
        objectArray[309] = caretColor;
        objectArray[310] = "PasswordField.focusInputMap";
        objectArray[311] = fieldInputMap;
        objectArray[312] = "PasswordField.background";
        objectArray[313] = Colors.getWhite();
        objectArray[314] = "EditorPane.margin";
        objectArray[315] = textFieldMargin;
        objectArray[316] = "EditorPane.font";
        objectArray[317] = fontDialog12;
        objectArray[318] = "EditorPane.caretForeground";
        objectArray[319] = caretColor;
        objectArray[320] = "EditorPane.focusInputMap";
        objectArray[321] = multilineInputMap;
        objectArray[322] = "EditorPane.background";
        objectArray[323] = Colors.getWhite();
        objectArray[324] = "TextPane.margin";
        objectArray[325] = textFieldMargin;
        objectArray[326] = "TextPane.font";
        objectArray[327] = fontDialog12;
        objectArray[328] = "TextPane.caretForeground";
        objectArray[329] = caretColor;
        objectArray[330] = "TextPane.focusInputMap";
        objectArray[331] = multilineInputMap;
        objectArray[332] = "TextPane.background";
        objectArray[333] = Colors.getWhite();
        objectArray[334] = "TextArea.margin";
        objectArray[335] = textFieldMargin;
        objectArray[336] = "TextArea.font";
        objectArray[337] = fontDialog12;
        objectArray[338] = "TextArea.caretForeground";
        objectArray[339] = caretColor;
        objectArray[340] = "TextArea.focusInputMap";
        objectArray[341] = multilineInputMap;
        objectArray[342] = "TextArea.background";
        objectArray[343] = Colors.getWhite();
        objectArray[344] = "TitledBorder.font";
        objectArray[345] = Colors.getWhite();
        objectArray[346] = "ToolBar.background";
        objectArray[347] = COLORS.getToolbarColors()[0];
        objectArray[348] = "ToolBar.margin";
        objectArray[349] = new InsetsUIResource(0, 0, 0, 0);
        objectArray[350] = "ToolBar.dockingForeground";
        objectArray[351] = Color.ORANGE;
        objectArray[352] = "ToolBar.ancestorInputMap";
        objectArray[353] = new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"});
        objectArray[354] = "ToolTip.font";
        objectArray[355] = fontDialog12;
        objectArray[356] = "tooltip.border";
        objectArray[357] = toolTipBorder;
        objectArray[358] = "Tree.background";
        objectArray[359] = RapidLookAndFeel.getWhiteBackground();
        objectArray[360] = "Tree.font";
        objectArray[361] = fontDialog12;
        objectArray[362] = "Tree.selectionBorder";
        objectArray[363] = focusCellHighlightBorder;
        objectArray[364] = "Tree.editorBorder";
        objectArray[365] = focusCellHighlightBorder;
        objectArray[366] = "Tree.line";
        objectArray[367] = new ColorUIResource(220, 220, 220);
        objectArray[368] = "Tree.selectionBorderColor";
        objectArray[369] = COLORS.getTextHighlightBackColor().brighter();
        objectArray[370] = "Tree.openIcon";
        objectArray[371] = SwingTools.createImage("plaf/tree_open.png");
        objectArray[372] = "Tree.closedIcon";
        objectArray[373] = SwingTools.createImage("plaf/tree_closed.png");
        objectArray[374] = "Tree.leafIcon";
        objectArray[375] = SwingTools.createImage("plaf/tree_leaf.png");
        objectArray[376] = "Tree.expandedIcon";
        objectArray[377] = SwingTools.createImage("plaf/tree_expanded.png");
        objectArray[378] = "Tree.collapsedIcon";
        objectArray[379] = SwingTools.createImage("plaf/tree_collapsed.png");
        objectArray[380] = "Tree.focusInputMap";
        objectArray[381] = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "shift END", "selectLastExtendSelection", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "ctrl HOME", "selectFirstChangeLead", "ctrl END", "selectLastChangeLead", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"});
        objectArray[382] = "Tree.ancestorInputMap";
        objectArray[383] = new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"});
        Object[] defaults = objectArray;
        table.putDefaults(defaults);
        RapidLookAndFeel.getColors().addCustomEntriesToTable(table);
        this.initBorderDefaults(table);
    }

    private static Color getWhiteBackground() {
        return Color.WHITE;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"SpinnerUI", "com.rapidminer.gui.look.ui.SpinnerUI", "FileChooserUI", "com.rapidminer.gui.look.fc.FileChooserUI", "ToolBarUI", "com.rapidminer.gui.look.ui.ToolBarUI", "DesktopIconUI", "com.rapidminer.gui.look.ui.DesktopIconUI", "SliderUI", "com.rapidminer.gui.look.ui.SliderUI", "CheckBoxUI", "com.rapidminer.gui.look.ui.CheckBoxUI", "ComboBoxUI", "com.rapidminer.gui.look.ui.ComboBoxUI", "RadioButtonUI", "com.rapidminer.gui.look.ui.RadioButtonUI", "TextFieldUI", "com.rapidminer.gui.look.ui.TextFieldUI", "FormattedTextFieldUI", "com.rapidminer.gui.look.ui.FormattedTextFieldUI", "PasswordFieldUI", "com.rapidminer.gui.look.ui.PasswordFieldUI", "EditorPaneUI", "com.rapidminer.gui.look.ui.EditorPaneUI", "TextPaneUI", "com.rapidminer.gui.look.ui.TextPaneUI", "TextAreaUI", "com.rapidminer.gui.look.ui.TextAreaUI", "ProgressBarUI", "com.rapidminer.gui.look.ui.ProgressBarUI", "TreeUI", "com.rapidminer.gui.look.ui.TreeUI", "SplitPaneUI", "com.rapidminer.gui.look.ui.SplitPaneUI", "ScrollBarUI", "com.rapidminer.gui.look.ui.ScrollBarUI", "ButtonUI", "com.rapidminer.gui.look.ui.ButtonUI", "ToggleButtonUI", "com.rapidminer.gui.look.ui.ToggleButtonUI", "TabbedPaneUI", "com.rapidminer.gui.look.ui.TabbedPaneUI", "TableUI", "com.rapidminer.gui.look.ui.TableUI", "TableHeaderUI", "com.rapidminer.gui.look.ui.TableHeaderUI", "MenuUI", "com.rapidminer.gui.look.ui.MenuUI", "MenuBarUI", "com.rapidminer.gui.look.ui.MenuBarUI", "MenuItemUI", "com.rapidminer.gui.look.ui.MenuItemUI", "RadioButtonMenuItemUI", "com.rapidminer.gui.look.ui.RadioButtonMenuItemUI", "CheckBoxMenuItemUI", "com.rapidminer.gui.look.ui.CheckBoxMenuItemUI", "PopupMenuSeparatorUI", "com.rapidminer.gui.look.ui.PopupMenuSeparatorUI", "InternalFrameUI", "com.rapidminer.gui.look.ui.InternalFrameUI", "LabelUI", "com.rapidminer.gui.look.ui.LabelUI", "ListUI", "com.rapidminer.gui.look.ui.ListUI"};
        table.putDefaults(uiDefaults);
    }

    private void initBorderDefaults(UIDefaults table) {
        Object[] borderDefaults = new Object[]{"a", IconFactory.getSliderThumb(), "TextField.border", Borders.getTextFieldBorder(), "PasswordField.border", Borders.getTextFieldBorder(), "FormattedTextField.border", Borders.getTextFieldBorder(), "SplitPane.border", Borders.getSplitPaneBorder(), "ScrollPane.border", Borders.getScrollPaneBorder(), "InternalFrame.border", Borders.getInternalFrameBorder(), "Table.scrollPaneBorder", Borders.getSplitPaneBorder(), "ToolBar.border", Borders.getToolBarBorder(), "Spinner.border", Borders.getSpinnerBorder(), "ComboBox.border", Borders.getComboBoxBorder(), "Button.border", Borders.getEmptyButtonBorder(), "ToggleButton.border", Borders.getEmptyButtonBorder(), "ProgressBar.border", Borders.getProgressBarBorder(), "PopupMenu.border", Borders.getPopupMenuBorder(), "MenuBar.border", Borders.getMenuBarBorder(), "CheckBox.border", Borders.getCheckBoxBorder(), "RadioButton.border", Borders.getCheckBoxBorder(), "ToolTip.border", Borders.getToolTipBorder(), "CheckBox.icon", IconFactory.getCheckBoxIcon(), "RadioButton.icon", IconFactory.getRadioButtonIcon(), "ComboBox.focusCellHighlightBorder", Borders.getComboBoxListCellRendererFocusBorder()};
        table.putDefaults(borderDefaults);
    }

    public static ColorUIResource getDesktopColor() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getControlShadow() {
        return new ColorUIResource(50, 50, 50);
    }

    public static ColorUIResource getControlDarkShadow() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getControlHighlight() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getPrimaryControl() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return new ColorUIResource(180, 180, 180);
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return new ColorUIResource(70, 70, 70);
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getSystemTextColor() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getControlTextColor() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getInactiveControlTextColor() {
        return new ColorUIResource(150, 150, 150);
    }

    public static ColorUIResource getTextBackground() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getUserTextColor() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getTextHighlightBackColor() {
        return new ColorUIResource(90, 110, 170);
    }

    public static ColorUIResource getHighlightedTextColor() {
        return new ColorUIResource(Color.white);
    }

    public static ColorUIResource getInactiveSystemTextColor() {
        return new ColorUIResource(180, 180, 180);
    }

    public static ColorUIResource getWindowTitleBackground() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getWindowTitleForeground() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getMenuBackground() {
        return new ColorUIResource(250, 250, 250);
    }

    public static ColorUIResource getMenuForeground() {
        return new ColorUIResource(0, 0, 0);
    }

    public static ColorUIResource getMenuSelectedBackground() {
        return new ColorUIResource(40, 115, 217);
    }

    public static ColorUIResource getMenuSelectedForeground() {
        return new ColorUIResource(255, 255, 255);
    }

    public static ColorUIResource getMenuDisabledForeground() {
        return new ColorUIResource(180, 180, 180);
    }

    public static ColorUIResource getMenuSelectedBack() {
        return new ColorUIResource(90, 110, 170);
    }

    public static ColorUIResource getWindowBackground() {
        return new ColorUIResource(90, 110, 170);
    }

    public static FontUIResource getMainFont() {
        return new FontUIResource("Dialog", 0, 12);
    }

    public static FontUIResource getTextfieldFont() {
        return new FontUIResource("Dialog", 0, 12);
    }

    public ColorUIResource getTextHighlightColor() {
        return RapidLookAndFeel.getColors().getTextHighlightBackColor();
    }
}

