/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.extraction;

import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.TextExtractionWrapper;
import com.rapidminer.operator.extraction.TextExtractor;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.generic.inputfilter.WVTInputFilter;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.WVToolException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;

public class ExtractingInputFilter
implements WVTInputFilter {
    private final TextExtractor extractor;
    private final WVTConfiguration config;

    public ExtractingInputFilter(WVTConfiguration config, TextExtractor extractor) {
        this.config = config;
        this.extractor = extractor;
    }

    public Reader convertToPlainText(InputStream inStream, WVTDocumentInfo d) throws WVToolException {
        try {
            inStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringBuffer text = new StringBuffer();
        try {
            TextExtractionWrapper extractionWrapper = new TextExtractionWrapper(d, this.config, false);
            Iterator<String> values = extractionWrapper.getValues(this.extractor);
            while (values.hasNext()) {
                text.append(values.next());
                text.append(' ');
            }
        }
        catch (ExtractionException e) {
            throw new WVToolException("Could not extract main text from file " + d.getSourceName(), (Throwable)e);
        }
        return new StringReader(text.toString());
    }
}

