/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ExampleTableOutputFilter;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.WVToolRapidMinerLogger;
import com.rapidminer.operator.extraction.AttributeQueryMap;
import com.rapidminer.operator.extraction.DefaultFeatureExtractor;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.FeatureExtractor;
import com.rapidminer.operator.extraction.util.ConcatanatedFeatureExtractor;
import com.rapidminer.operator.extraction.util.FeatureExtractionUtil;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LoggingHandler;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTInputList;
import edu.udo.cs.wvtool.main.WVTWordVector;
import edu.udo.cs.wvtool.util.WVToolLogger;
import edu.udo.cs.wvtool.wordlist.WVTWordList;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureExtractor
extends Operator {
    public static final String PARAMETER_EXTRACTOR_CLASS = "extractor_class";
    private WVTConfiguration config = new WVTConfiguration();
    private Process externalExperiment = null;

    public AbstractFeatureExtractor(OperatorDescription description) {
        super(description);
    }

    public Process getExternalExperiment() {
        return this.externalExperiment;
    }

    public void setExternalExperiment(Process process) {
        this.externalExperiment = process;
    }

    protected abstract WVTInputList createInputList() throws OperatorException;

    protected abstract Attribute getLabel() throws OperatorException;

    public Process getProcess() {
        Process associatedExperiment = super.getProcess();
        if (associatedExperiment == null) {
            associatedExperiment = this.externalExperiment;
        }
        return associatedExperiment;
    }

    protected String resolveFilename(String name) throws IOException {
        Process associatedExperiment = this.getProcess();
        if (associatedExperiment != null) {
            return associatedExperiment.resolveFileName(name).getAbsolutePath();
        }
        return new File(name).getAbsolutePath();
    }

    public IOObject[] apply() throws OperatorException {
        WVToolLogger.setGlobalLogger((WVToolLogger)new WVToolRapidMinerLogger((LoggingHandler)this));
        WVTInputList list = this.createInputList();
        String featureExtractorClassName = this.getParameterAsString(PARAMETER_EXTRACTOR_CLASS);
        FeatureExtractor extractorExt = null;
        if (featureExtractorClassName != null && featureExtractorClassName.length() > 0) {
            Class<?> c = null;
            try {
                c = Class.forName(featureExtractorClassName);
                extractorExt = (FeatureExtractor)c.newInstance();
            }
            catch (Throwable t) {
                extractorExt = null;
                this.logWarning("Could not initialize the extractor. Ignoring it.");
            }
        }
        WVTWordList wordList = new WVTWordList(0);
        DefaultFeatureExtractor features = null;
        AttributeQueryMap aqMap = null;
        try {
            aqMap = FeatureExtractionUtil.getAttributeQueryMap(this.getParameters());
        }
        catch (ExtractionException e3) {
            UserError error = e3.getUserError();
            error.setOperator((Operator)this);
            throw error;
        }
        if (aqMap.getAttributes().size() > 0) {
            features = new DefaultFeatureExtractor(aqMap, this.config);
        }
        FeatureExtractor combinedExtractor = null;
        if (extractorExt != null && features != null) {
            combinedExtractor = new ConcatanatedFeatureExtractor(new FeatureExtractor[]{extractorExt, features});
        } else if (extractorExt != null) {
            combinedExtractor = extractorExt;
        } else if (features != null) {
            combinedExtractor = features;
        }
        ExampleTableOutputFilter out = new ExampleTableOutputFilter(this.getLabel(), wordList, this.getParameterAsBoolean("use_content_attributes"), this.getParameterAsInt("id_attribute_type"), combinedExtractor, null, (LoggingHandler)this);
        Iterator it = list.getEntries();
        while (it.hasNext()) {
            WVTDocumentInfo docInfo = (WVTDocumentInfo)it.next();
            WVTWordVector vector = new WVTWordVector();
            vector.setDocumentInfo(docInfo);
            vector.setValues(new double[0]);
            out.write(vector);
        }
        return new IOObject[]{out.createExampleSet()};
    }

    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString("default_content_type", "The default content type if not specified by the example set (possible values: pdf, html, htm, xml, text, txt).", ""));
        types.add(new ParameterTypeString("default_content_encoding", "The default content encoding if not specified by the example set (only encodings supported by Java can be used).", ""));
        types.add(new ParameterTypeString("default_content_language", "The default content language if not specified by the example set.", ""));
        types.add(new ParameterTypeBoolean("use_content_attributes", "If set to true, the returned example set will contain content type, encoding, and language attributes.", false));
        types.add(new ParameterTypeCategory("id_attribute_type", "Indicates if long ids (complete paths), short ids (last part of the source name), or numerical ids will be used.", ExampleTableOutputFilter.ID_TYPE_NAMES, 2));
        ParameterType featuresType = FeatureExtractionUtil.createQueryParameter();
        featuresType.setExpert(true);
        types.add(featuresType);
        ParameterType param = FeatureExtractionUtil.createNamespaceParameter();
        types.add(param);
        types.add(new ParameterTypeString(PARAMETER_EXTRACTOR_CLASS, "Full reference to class that performs additional information extraction. This class must be a subclass of FeatureExtractor."));
        return types;
    }
}

