/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import com.rapidminer.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.Iterator;

public class RunVector
extends ResultObjectAdapter {
    private static final long serialVersionUID = -5481280692066966385L;
    private ArrayList<AverageVector> vectorList = new ArrayList();

    public void addVector(AverageVector av) {
        this.vectorList.add(av);
    }

    public AverageVector getVector(int index) {
        return this.vectorList.get(index);
    }

    public ArrayList getVectorList() {
        return this.vectorList;
    }

    public int size() {
        return this.vectorList.size();
    }

    public AverageVector average() {
        try {
            AverageVector output = (AverageVector)this.getVector(0).clone();
            int i = 1;
            while (i < this.size()) {
                AverageVector av = this.getVector(i);
                int j = 0;
                while (j < av.size()) {
                    output.getAveragable(j).buildAverage(av.getAveragable(j));
                    ++j;
                }
                ++i;
            }
            return output;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone of average vector is not supported: " + e.getMessage());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("RunVector:" + Tools.getLineSeparator());
        Iterator<AverageVector> i = this.vectorList.iterator();
        while (i.hasNext()) {
            result.append(i.next() + Tools.getLineSeparator());
        }
        return result.toString();
    }

    public String toResultString() {
        StringBuffer result = new StringBuffer("");
        AverageVector averageVector = this.average();
        int averagableIndex = 0;
        while (averagableIndex < averageVector.size()) {
            result.append("Time series of averagable '" + this.getVector(0).getAveragable(averagableIndex).getName() + "':");
            int timeIndex = 0;
            while (timeIndex < this.size()) {
                AverageVector currentAveragables = this.getVector(timeIndex);
                Averagable averagable = currentAveragables.getAveragable(averagableIndex);
                result.append("  " + averagable.getAverage());
                ++timeIndex;
            }
            result.append(Tools.getLineSeparator());
            ++averagableIndex;
        }
        int i = 0;
        while (i < averageVector.size()) {
            Averagable averagable = averageVector.getAveragable(i);
            result.append("  Average of averagable '" + averagable.getName() + "':  " + averagable.getAverage());
            if (averagable.getVariance() >= 0.0) {
                result.append("  (" + averagable.getVariance() + ")");
            }
            result.append(Tools.getLineSeparator());
            ++i;
        }
        result.append(Tools.getLineSeparator());
        return result.toString();
    }

    public String getExtension() {
        return "rvc";
    }

    public String getFileDescription() {
        return "run vector";
    }
}

