/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.NoBugError;
import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.log.DeleteLogFormatFilter;
import com.rapidminer.tools.log.DummyLogFormatFilter;
import com.rapidminer.tools.log.FormattedFilterStream;
import com.rapidminer.tools.log.StreamMultiplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class LogService
implements LoggingHandler {
    public static final String GLOBAL_PREFIX = "$gG^g";
    public static final int UNKNOWN_LEVEL = -1;
    public static final int MINIMUM = 0;
    public static final int IO = 1;
    public static final int STATUS = 2;
    public static final int INIT = 3;
    public static final int NOTE = 4;
    public static final int WARNING = 5;
    public static final int ERROR = 6;
    public static final int FATAL = 7;
    public static final int MAXIMUM = 8;
    public static final int OFF = 9;
    public static final String[] LOG_VERBOSITY_NAMES = new String[]{"all", "io", "status", "init", "notes", "warning", "error", "fatal", "almost_none", "off"};
    private static final String[] VERBOSITYLEVEL_START = new String[]{"", "", "", "", "$n$b[NOTE]^b ", "$w$b[Warning]^b ", "$e$b[Error]^b ", "$e$b[Fatal]^b ", "", ""};
    private static final String[] VERBOSITYLEVEL_END = new String[]{"", "", "", "", "^n", "^w", "^e", "^e", "", ""};
    private static LogService globalLogging = null;
    private PrintStream logOut = System.out;
    private int minVerbosityLevel = 3;
    private String lastMessage;
    private int equalMessageCount;
    private File logFile = null;
    private String prefix = "$gG^g";
    private Process process = null;

    public LogService(Process process) throws UndefinedParameterError {
        this(process, -1);
    }

    public LogService(Process process, int logVerbosity) throws UndefinedParameterError {
        this.process = process;
        int verbosityLevel = logVerbosity;
        if (verbosityLevel == -1) {
            verbosityLevel = process.getRootOperator().getParameterAsInt("logverbosity");
        }
        String fileName = process.getRootOperator().getParameterAsString("logfile");
        this.init(fileName, verbosityLevel, "$gP^g");
    }

    private LogService() {
        this.init(System.out, 3, false, GLOBAL_PREFIX);
    }

    public static synchronized LogService getGlobal() {
        if (globalLogging == null) {
            globalLogging = new LogService();
            String globalLogFile = System.getProperty("rapidminer.global.logging.file");
            String globalLogVerbosity = System.getProperty("rapidminer.global.logging.verbosity");
            int logVerbosity = LogService.getVerbosityLevel(globalLogVerbosity);
            if (logVerbosity < -1 || logVerbosity >= LOG_VERBOSITY_NAMES.length) {
                globalLogging.logError("Only numbers between 0 and 8 or one of the log verbosity level names are allowed as value for rapidminer.global.logging.verbosity. Was: '" + globalLogVerbosity + "'. Using INIT instead...");
                logVerbosity = 3;
            }
            globalLogging.init(globalLogFile, logVerbosity, GLOBAL_PREFIX);
        }
        return globalLogging;
    }

    public static void initGlobalLogging(OutputStream out, int logVerbosity) {
        LogService.getGlobal().init(out, logVerbosity, false, GLOBAL_PREFIX);
    }

    private void init(String fileName, int verbosityLevel, String prefix) {
        if (fileName == null) {
            this.logFile = null;
            this.init(System.out, verbosityLevel, false, prefix);
        } else if (fileName.equals("stderr")) {
            this.logFile = null;
            this.init(System.err, verbosityLevel, false, prefix);
            this.log("Logging: log file name is 'stderr', using system err for logging.", 3);
        } else if (fileName.equals("stdout")) {
            this.logFile = null;
            this.init(System.out, verbosityLevel, false, prefix);
            this.log("Logging: log file name is 'stdout', using system out for logging.", 3);
        } else {
            this.logFile = this.process != null ? this.process.resolveFileName(fileName) : new File(fileName);
            OutputStream out = null;
            try {
                out = new FileOutputStream(this.logFile);
            }
            catch (IOException e) {
                this.log("Cannot create logfile '" + fileName + "': " + e.getClass() + ":" + e.getMessage(), 8);
                this.log("using stdout", 8);
                out = System.out;
            }
            this.init(out, verbosityLevel, false, prefix);
            this.log("Logging: log file is '" + this.logFile.getName() + "'...", 3);
        }
    }

    private void init(OutputStream out, int verbosityLevel, boolean format, String prefix) {
        this.logOut = format ? new PrintStream(new FormattedFilterStream(out, new DummyLogFormatFilter())) : new PrintStream(new FormattedFilterStream(out, new DeleteLogFormatFilter()));
        this.prefix = prefix;
        this.minVerbosityLevel = verbosityLevel == -1 ? 3 : verbosityLevel;
        this.lastMessage = "";
        this.equalMessageCount = 0;
        if (RapidMinerGUI.getMainFrame() != null) {
            try {
                this.initGUI();
            }
            catch (UndefinedParameterError e) {
                this.log("Cannot initialize GUI logging: " + e.getMessage(), 6);
                e.printStackTrace();
            }
        }
    }

    public void initGUI() throws UndefinedParameterError {
        if (RapidMinerGUI.getMainFrame() != null) {
            if (this.process != null) {
                this.minVerbosityLevel = this.process.getRootOperator().getParameterAsInt("logverbosity");
                String logFileName = this.process.getRootOperator().getParameterAsString("logfile");
                this.logFile = this.process.resolveFileName(logFileName);
            } else {
                this.logFile = null;
            }
            if (this.logFile != null) {
                try {
                    this.logOut = new PrintStream(new StreamMultiplier(new FormattedFilterStream(new FileOutputStream(this.logFile), new DeleteLogFormatFilter()), new FormattedFilterStream(RapidMinerGUI.getMainFrame().getMessageViewer().outputStream, new DummyLogFormatFilter())));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot create log file: " + e);
                }
            } else {
                this.logOut = new PrintStream(RapidMinerGUI.getMainFrame().getMessageViewer().outputStream);
            }
        }
    }

    public void flush() {
        this.logOut.flush();
    }

    public void setVerbosityLevel(int level) {
        this.minVerbosityLevel = level;
    }

    public int getVerbosityLevel() {
        return this.minVerbosityLevel;
    }

    public boolean isSufficientLogVerbosity(int level) {
        return level >= this.minVerbosityLevel;
    }

    @Deprecated
    public static void logMessage(String message, int verbosityLevel) {
        LogService.getGlobal().log(message, verbosityLevel);
    }

    public void log(String message, int verbosityLevel) {
        if (message == null) {
            return;
        }
        if (verbosityLevel < this.minVerbosityLevel) {
            return;
        }
        if (message.equals(this.lastMessage)) {
            ++this.equalMessageCount;
            return;
        }
        if (this.equalMessageCount > 0) {
            this.logOut.println("Last message repeated " + this.equalMessageCount + " times.");
            this.equalMessageCount = 0;
        }
        this.lastMessage = message;
        this.logOut.println(String.valueOf(this.prefix) + " " + this.getTime() + " " + VERBOSITYLEVEL_START[verbosityLevel] + message + VERBOSITYLEVEL_END[verbosityLevel]);
    }

    private void logMessageWithTree(String message, int verbosityLevel, Process process, Operator op) {
        if (verbosityLevel < this.minVerbosityLevel) {
            return;
        }
        this.log(message, verbosityLevel);
        String treeString = process.getRootOperator().createMarkedProcessTree(10, " here ==> ", op);
        this.logOut.println("$m" + treeString + "^m");
    }

    public void logFinalException(String message, Process process, Throwable exception, boolean debugMode) {
        if (7 < this.minVerbosityLevel) {
            return;
        }
        Operator op = null;
        if (process != null) {
            op = process.getCurrentOperator();
        }
        if (op != null) {
            this.log(String.valueOf(Tools.classNameWOPackage(exception.getClass())) + " occured in " + Tools.ordinalNumber(op.getApplyCount()) + " application of " + op, 7);
            this.logMessageWithTree(message, 7, process, op);
        } else {
            this.log(String.valueOf(Tools.classNameWOPackage(exception.getClass())) + " occured.", 7);
            this.log(message, 7);
        }
        if (!(exception instanceof NoBugError) && debugMode) {
            this.log(exception.getMessage(), 7);
            exception.printStackTrace(this.logOut);
        }
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void log(String message) {
        this.log(message, 2);
    }

    public void logError(String message) {
        this.log(message, 6);
    }

    public void logNote(String message) {
        this.log(message, 4);
    }

    public void logWarning(String message) {
        this.log(message, 5);
    }

    private String getTime() {
        return String.valueOf(DateFormat.getDateTimeInstance().format(new Date())) + ":";
    }

    /*
     * Unable to fully structure code
     */
    private static int getVerbosityLevel(String verbosityString) {
        if (verbosityString == null || verbosityString.trim().length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(verbosityString);
        }
        catch (NumberFormatException e) {
            counter = 0;
            var6_3 = LogService.LOG_VERBOSITY_NAMES;
            var5_4 = LogService.LOG_VERBOSITY_NAMES.length;
            var4_5 = 0;
            ** while (var4_5 < var5_4)
        }
lbl-1000:
        // 1 sources

        {
            name = var6_3[var4_5];
            if (name.equals(verbosityString)) {
                return counter;
            }
            ++counter;
            ++var4_5;
            continue;
        }
lbl17:
        // 1 sources

        return -1;
    }
}

