/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.operator.OperatorDescription;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupTree
implements Comparable<GroupTree> {
    private Set<OperatorDescription> operators = new TreeSet<OperatorDescription>();
    private Map<String, GroupTree> children = new TreeMap<String, GroupTree>();
    private String name = null;
    private GroupTree parent = null;

    public GroupTree(String name) {
        this.name = name;
    }

    public GroupTree(GroupTree other) {
        this.name = other.name;
        this.operators.addAll(other.operators);
        for (GroupTree child : other.getSubGroups()) {
            this.addSubGroup((GroupTree)child.clone());
        }
    }

    public Object clone() {
        return new GroupTree(this);
    }

    public String getName() {
        return this.name;
    }

    public String getMainGroupName() {
        if (this.getParent() == null) {
            return "Root";
        }
        if (this.getParent().getParent() == null) {
            return this.getName();
        }
        return this.getParent().getMainGroupName();
    }

    private void setParent(GroupTree parent) {
        this.parent = parent;
    }

    private GroupTree getParent() {
        return this.parent;
    }

    public void addSubGroup(GroupTree child) {
        this.children.put(child.getName(), child);
        child.setParent(this);
    }

    public GroupTree getSubGroup(String name) {
        return this.children.get(name);
    }

    public Collection<GroupTree> getSubGroups() {
        return this.children.values();
    }

    public int getIndexOfSubGroup(GroupTree child) {
        Iterator<GroupTree> i = this.getSubGroups().iterator();
        int index = 0;
        while (i.hasNext()) {
            GroupTree current = i.next();
            if (current.equals(child)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public GroupTree getSubGroup(int index) {
        Collection<GroupTree> allChildren = this.getSubGroups();
        if (index >= allChildren.size()) {
            return null;
        }
        Iterator<GroupTree> i = allChildren.iterator();
        int counter = 0;
        while (i.hasNext()) {
            GroupTree current = i.next();
            if (counter == index) {
                return current;
            }
            ++counter;
        }
        return null;
    }

    public void addOperatorDescription(OperatorDescription description) {
        this.operators.add(description);
    }

    public Set<OperatorDescription> getOperatorDescriptions() {
        return this.operators;
    }

    public Set<OperatorDescription> getAllOperatorDescriptions() {
        TreeSet<OperatorDescription> result = new TreeSet<OperatorDescription>();
        this.addAllOperatorDescriptions(result);
        return result;
    }

    private void addAllOperatorDescriptions(Set<OperatorDescription> operators) {
        operators.addAll(this.operators);
        for (GroupTree child : this.children.values()) {
            child.addAllOperatorDescriptions(operators);
        }
    }

    public String toString() {
        String result = this.name;
        if (this.getParent() == null) {
            result = "Root";
        }
        return String.valueOf(result) + (this.getOperatorDescriptions().size() > 0 ? " (" + this.getOperatorDescriptions().size() + ")" : "");
    }

    @Override
    public int compareTo(GroupTree o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupTree)) {
            return false;
        }
        GroupTree a = (GroupTree)o;
        return this.name.equals(a.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

