/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.BinominalMapping;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.tools.Tools;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class NominalToBinominalModel
extends PreprocessingModel {
    private static final long serialVersionUID = 2882937201039541604L;
    private Set<String> sourceAttributeNames;
    private Map<Attribute, Double> binominalAttributeValueMap = new LinkedHashMap<Attribute, Double>();
    private boolean useOnlyUnderscoreInNames = false;

    public NominalToBinominalModel(ExampleSet exampleSet, boolean translateBinominals, boolean useOnlyUnderscoreInNames) {
        super(exampleSet);
        this.useOnlyUnderscoreInNames = useOnlyUnderscoreInNames;
        this.sourceAttributeNames = new HashSet<String>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal() || attribute.getMapping().size() <= 2 && !translateBinominals) continue;
            this.sourceAttributeNames.add(attribute.getName());
        }
    }

    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        LinkedHashMap<Attribute, Attribute> attributeSourceMap = new LinkedHashMap<Attribute, Attribute>();
        for (Attribute sourceAttribute : exampleSet.getAttributes()) {
            String sourceAttributeName = sourceAttribute.getName();
            if (!this.sourceAttributeNames.contains(sourceAttributeName)) continue;
            for (String string : sourceAttribute.getMapping().getValues()) {
                Attribute newAttribute = AttributeFactory.createAttribute(String.valueOf(sourceAttributeName) + " = " + string, 6);
                BinominalMapping mapping = new BinominalMapping();
                mapping.mapString("false");
                mapping.mapString("true");
                newAttribute.setMapping(mapping);
                this.binominalAttributeValueMap.put(newAttribute, Double.valueOf(sourceAttribute.getMapping().mapString(string)));
                attributeSourceMap.put(newAttribute, sourceAttribute);
            }
        }
        exampleSet.getExampleTable().addAttributes(attributeSourceMap.keySet());
        Attributes attributes = exampleSet.getAttributes();
        for (Attribute attribute : attributeSourceMap.keySet()) {
            attributes.addRegular(attribute);
        }
        this.binominalAttributeValueMap = new LinkedHashMap<Attribute, Double>(this.binominalAttributeValueMap);
        for (Example example : exampleSet) {
            for (Map.Entry entry : attributeSourceMap.entrySet()) {
                double sourceValue = example.getValue((Attribute)entry.getValue());
                example.setValue((Attribute)entry.getKey(), this.getValue((Attribute)entry.getKey(), sourceValue));
            }
        }
        Iterator<Attribute> attributeIterator = attributes.iterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            if (!this.sourceAttributeNames.contains(attribute.getName())) continue;
            attributeIterator.remove();
        }
        return exampleSet;
    }

    public Attributes getTargetAttributes(ExampleSet applySet) {
        Attributes attributes = this.getSpecialAttributes(applySet);
        for (Attribute attribute : applySet.getAttributes()) {
            if (this.sourceAttributeNames.contains(attribute.getName())) {
                for (String value : attribute.getMapping().getValues()) {
                    attributes.addRegular(this.createBinominalValueAttribute(attribute, value));
                }
                continue;
            }
            attributes.addRegular(attribute);
        }
        return attributes;
    }

    public double getValue(Attribute targetAttribute, double value) {
        if (Double.compare(value, this.binominalAttributeValueMap.get(targetAttribute)) == 0) {
            return 1.0;
        }
        return 0.0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Mapping Model for attributes:");
        for (String attributeName : this.sourceAttributeNames) {
            buffer.append(String.valueOf(attributeName) + Tools.getLineSeparator());
        }
        return buffer.toString();
    }

    private Attribute createBinominalValueAttribute(Attribute attribute, String value) {
        BinominalMapping mapping = new BinominalMapping();
        mapping.mapString("false");
        mapping.mapString("true");
        String newName = String.valueOf(attribute.getName()) + " = " + value;
        if (this.useOnlyUnderscoreInNames) {
            newName = String.valueOf(attribute.getName()) + "_" + value;
        }
        ViewAttribute newAttribute = new ViewAttribute(this, attribute, newName, 6, mapping);
        this.binominalAttributeValueMap.put(newAttribute, Double.valueOf(attribute.getMapping().mapString(value)));
        return newAttribute;
    }

    private Attributes getSpecialAttributes(ExampleSet applySet) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> roleIterator = applySet.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = roleIterator.next();
            if (!role.isSpecial()) continue;
            attributes.add(role);
        }
        return attributes;
    }
}

