/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance.cost;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.performance.cost.ClassificationCostCriterion;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeMatrix;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CostEvaluator
extends Operator {
    private static final String PARAMETER_COST_MATRIX = "cost_matrix";
    private static final String PARAMETER_KEEP_EXAMPLE_SET = "keep_exampleSet";

    public CostEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label != null && label.isNominal()) {
            double[][] costMatrix = this.getParameterAsMatrix(PARAMETER_COST_MATRIX);
            ClassificationCostCriterion criterion = new ClassificationCostCriterion(costMatrix, label, exampleSet.getAttributes().getPredictedLabel());
            PerformanceVector performance = new PerformanceVector();
            performance.addCriterion(criterion);
            criterion.startCounting(exampleSet, false);
            for (Example example : exampleSet) {
                ((MeasuredPerformance)criterion).countExample(example);
            }
            if (this.getParameterAsBoolean(PARAMETER_KEEP_EXAMPLE_SET)) {
                return new IOObject[]{exampleSet, performance};
            }
            return new IOObject[]{performance};
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_EXAMPLE_SET, "Indicates if the example set should be kept.", false));
        types.add(new ParameterTypeMatrix(PARAMETER_COST_MATRIX, "The cost matrix in Matlab single line format", "Cost Matrix", "Predicted Class", "True Class", true, false));
        return types;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }
}

