/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class RootRelativeSquaredError
extends MeasuredPerformance {
    private static final long serialVersionUID = 7781104825149866444L;
    private Attribute predictedAttribute;
    private Attribute labelAttribute;
    private Attribute weightAttribute;
    private double deviationSum = 0.0;
    private double relativeSum = 0.0;
    private double trueLabelSum = 0.0;
    private double exampleCounter = 0.0;

    public RootRelativeSquaredError() {
    }

    public RootRelativeSquaredError(RootRelativeSquaredError rse) {
        super(rse);
        this.deviationSum = rse.deviationSum;
        this.relativeSum = rse.relativeSum;
        this.trueLabelSum = rse.trueLabelSum;
        this.exampleCounter = rse.exampleCounter;
        this.labelAttribute = (Attribute)rse.labelAttribute.clone();
        this.predictedAttribute = (Attribute)rse.predictedAttribute.clone();
        if (rse.weightAttribute != null) {
            this.weightAttribute = (Attribute)rse.weightAttribute.clone();
        }
    }

    public String getName() {
        return "root_relative_squared_error";
    }

    public String getDescription() {
        return "Averaged root-relative-squared error";
    }

    public double getExampleCount() {
        return this.exampleCounter;
    }

    public void startCounting(ExampleSet exampleSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(exampleSet, useExampleWeights);
        if (exampleSet.size() <= 1) {
            throw new UserError(null, 919, this.getName(), "root relative squared error can only be calculated for test sets with more than 2 examples.");
        }
        this.predictedAttribute = exampleSet.getAttributes().getPredictedLabel();
        this.labelAttribute = exampleSet.getAttributes().getLabel();
        if (useExampleWeights) {
            this.weightAttribute = exampleSet.getAttributes().getWeight();
        }
        this.trueLabelSum = 0.0;
        this.deviationSum = 0.0;
        this.relativeSum = 0.0;
        this.exampleCounter = 0.0;
        for (Example example : exampleSet) {
            double label = example.getValue(this.labelAttribute);
            if (Double.isNaN(label)) continue;
            this.exampleCounter += 1.0;
            this.trueLabelSum += label;
        }
    }

    public void countExample(Example example) {
        double plabel;
        double label = example.getValue(this.labelAttribute);
        if (!this.predictedAttribute.isNominal()) {
            plabel = example.getValue(this.predictedAttribute);
        } else {
            String labelS = example.getNominalValue(this.labelAttribute);
            plabel = example.getConfidence(labelS);
            label = 1.0;
        }
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        double diff = Math.abs(label - plabel);
        this.deviationSum += diff * diff * weight * weight;
        double relDiff = Math.abs(label - this.trueLabelSum / this.exampleCounter);
        this.relativeSum += relDiff * relDiff * weight * weight;
    }

    public double getMikroAverage() {
        return Math.sqrt(this.deviationSum / this.relativeSum);
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public double getFitness() {
        return -1.0 * this.getAverage();
    }

    public void buildSingleAverage(Averagable performance) {
        RootRelativeSquaredError other = (RootRelativeSquaredError)performance;
        this.deviationSum += other.deviationSum;
        this.relativeSum += other.relativeSum;
    }
}

