/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.tree.Benefit;
import com.rapidminer.operator.learner.tree.DecisionTreeLeafCreator;
import com.rapidminer.operator.learner.tree.EmptyTermination;
import com.rapidminer.operator.learner.tree.GainRatioCriterion;
import com.rapidminer.operator.learner.tree.MaxDepthTermination;
import com.rapidminer.operator.learner.tree.NoAttributeLeftTermination;
import com.rapidminer.operator.learner.tree.PessimisticPruner;
import com.rapidminer.operator.learner.tree.Pruner;
import com.rapidminer.operator.learner.tree.SingleLabelTermination;
import com.rapidminer.operator.learner.tree.Terminator;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeBuilder;
import com.rapidminer.operator.learner.tree.TreeModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelevanceTreeLearner
extends AbstractMetaLearner {
    public RelevanceTreeLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        TreeBuilder builder = new TreeBuilder(new GainRatioCriterion(0.0), this.getTerminationCriteria(exampleSet), this.getPruner(), null, new DecisionTreeLeafCreator(), this.getParameterAsBoolean("no_pre_pruning"), this.getParameterAsInt("number_of_prepruning_alternatives"), this.getParameterAsInt("minimal_size_for_split"), this.getParameterAsInt("minimal_leaf_size")){

            public Benefit calculateBenefit(ExampleSet exampleSet, Attribute attribute) throws OperatorException {
                ExampleSet trainingSet = (ExampleSet)exampleSet.clone();
                Operator weightOp = RelevanceTreeLearner.this.getOperator(0);
                double weight = Double.NaN;
                if (weightOp != null) {
                    IOContainer output = weightOp.apply(new IOContainer(trainingSet));
                    AttributeWeights weights = output.remove(AttributeWeights.class);
                    weight = weights.getWeight(attribute.getName());
                }
                if (!Double.isNaN(weight)) {
                    return new Benefit(weight, attribute);
                }
                return null;
            }
        };
        Tree root = builder.learnTree(exampleSet);
        return new TreeModel(exampleSet, root);
    }

    public Pruner getPruner() throws OperatorException {
        if (!this.getParameterAsBoolean("no_pruning")) {
            return new PessimisticPruner(this.getParameterAsDouble("confidence"), new DecisionTreeLeafCreator());
        }
        return null;
    }

    public List<Terminator> getTerminationCriteria(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Terminator> result = new LinkedList<Terminator>();
        result.add(new SingleLabelTermination());
        result.add(new NoAttributeLeftTermination());
        result.add(new EmptyTermination());
        int maxDepth = this.getParameterAsInt("maximal_depth");
        if (maxDepth <= 0) {
            maxDepth = exampleSet.size();
        }
        result.add(new MaxDepthTermination(maxDepth));
        return result;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{AttributeWeights.class});
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        if (capability == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        if (capability == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return capability == LearnerCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("minimal_size_for_split", "The minimal size of a node in order to allow a split.", 1, Integer.MAX_VALUE, 4);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("minimal_leaf_size", "The minimal size of all leaves.", 1, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("maximal_depth", "The maximum tree depth (-1: no bound)", -1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("confidence", "The confidence level used for pruning.", 1.0E-7, 0.5, 0.25);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("no_pruning", "Disables the pruning and delivers an unpruned tree.", false));
        return types;
    }
}

